package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeAutomationStepExecutionsResponse(
    stepExecutions: Optional[Iterable[zio.aws.ssm.model.StepExecution]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse = {
    import DescribeAutomationStepExecutionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse
      .builder()
      .optionallyWith(
        stepExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stepExecutions)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse
      .wrap(buildAwsValue())
}
object DescribeAutomationStepExecutionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse =
      zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse(
        stepExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def stepExecutions: Optional[List[zio.aws.ssm.model.StepExecution.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getStepExecutions
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.StepExecution.ReadOnly]] =
      AwsError.unwrapOptionField("stepExecutions", stepExecutions)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse
  ) extends zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly {
    override val stepExecutions
        : Optional[List[zio.aws.ssm.model.StepExecution.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.StepExecution.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAutomationStepExecutionsResponse
  ): zio.aws.ssm.model.DescribeAutomationStepExecutionsResponse.ReadOnly =
    new Wrapper(impl)
}
