package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{StreamUrl, TokenValue, SessionId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResumeSessionResponse(
    sessionId: Optional[SessionId] = Optional.Absent,
    tokenValue: Optional[TokenValue] = Optional.Absent,
    streamUrl: Optional[StreamUrl] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResumeSessionResponse = {
    import ResumeSessionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResumeSessionResponse
      .builder()
      .optionallyWith(
        sessionId.map(value => SessionId.unwrap(value): java.lang.String)
      )(_.sessionId)
      .optionallyWith(
        tokenValue.map(value => TokenValue.unwrap(value): java.lang.String)
      )(_.tokenValue)
      .optionallyWith(
        streamUrl.map(value => StreamUrl.unwrap(value): java.lang.String)
      )(_.streamUrl)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResumeSessionResponse.ReadOnly =
    zio.aws.ssm.model.ResumeSessionResponse.wrap(buildAwsValue())
}
object ResumeSessionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResumeSessionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResumeSessionResponse =
      zio.aws.ssm.model.ResumeSessionResponse(
        sessionId.map(value => value),
        tokenValue.map(value => value),
        streamUrl.map(value => value)
      )
    def sessionId: Optional[SessionId]
    def tokenValue: Optional[TokenValue]
    def streamUrl: Optional[StreamUrl]
    def getSessionId: ZIO[Any, AwsError, SessionId] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getTokenValue: ZIO[Any, AwsError, TokenValue] =
      AwsError.unwrapOptionField("tokenValue", tokenValue)
    def getStreamUrl: ZIO[Any, AwsError, StreamUrl] =
      AwsError.unwrapOptionField("streamUrl", streamUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResumeSessionResponse
  ) extends zio.aws.ssm.model.ResumeSessionResponse.ReadOnly {
    override val sessionId: Optional[SessionId] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => zio.aws.ssm.model.primitives.SessionId(value))
    override val tokenValue: Optional[TokenValue] = zio.aws.core.internal
      .optionalFromNullable(impl.tokenValue())
      .map(value => zio.aws.ssm.model.primitives.TokenValue(value))
    override val streamUrl: Optional[StreamUrl] = zio.aws.core.internal
      .optionalFromNullable(impl.streamUrl())
      .map(value => zio.aws.ssm.model.primitives.StreamUrl(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResumeSessionResponse
  ): zio.aws.ssm.model.ResumeSessionResponse.ReadOnly = new Wrapper(impl)
}
