package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AlarmConfiguration(
    ignorePollAlarmFailure: Optional[Boolean] = Optional.Absent,
    alarms: Iterable[zio.aws.ssm.model.Alarm]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AlarmConfiguration = {
    import AlarmConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AlarmConfiguration
      .builder()
      .optionallyWith(
        ignorePollAlarmFailure.map(value => value: java.lang.Boolean)
      )(_.ignorePollAlarmFailure)
      .alarms(alarms.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AlarmConfiguration.ReadOnly =
    zio.aws.ssm.model.AlarmConfiguration.wrap(buildAwsValue())
}
object AlarmConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AlarmConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AlarmConfiguration =
      zio.aws.ssm.model.AlarmConfiguration(
        ignorePollAlarmFailure.map(value => value),
        alarms.map { item =>
          item.asEditable
        }
      )
    def ignorePollAlarmFailure: Optional[Boolean]
    def alarms: List[zio.aws.ssm.model.Alarm.ReadOnly]
    def getIgnorePollAlarmFailure: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("ignorePollAlarmFailure", ignorePollAlarmFailure)
    def getAlarms: ZIO[Any, Nothing, List[zio.aws.ssm.model.Alarm.ReadOnly]] =
      ZIO.succeed(alarms)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AlarmConfiguration
  ) extends zio.aws.ssm.model.AlarmConfiguration.ReadOnly {
    override val ignorePollAlarmFailure: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ignorePollAlarmFailure())
        .map(value => value: Boolean)
    override val alarms: List[zio.aws.ssm.model.Alarm.ReadOnly] = impl
      .alarms()
      .asScala
      .map { item =>
        zio.aws.ssm.model.Alarm.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AlarmConfiguration
  ): zio.aws.ssm.model.AlarmConfiguration.ReadOnly = new Wrapper(impl)
}
