package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CancelMaintenanceWindowExecutionRequest(
    windowExecutionId: MaintenanceWindowExecutionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest = {
    import CancelMaintenanceWindowExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest
      .builder()
      .windowExecutionId(
        MaintenanceWindowExecutionId.unwrap(windowExecutionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest.ReadOnly =
    zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest
      .wrap(buildAwsValue())
}
object CancelMaintenanceWindowExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest =
      zio.aws.ssm.model
        .CancelMaintenanceWindowExecutionRequest(windowExecutionId)
    def windowExecutionId: MaintenanceWindowExecutionId
    def getWindowExecutionId: ZIO[Any, Nothing, MaintenanceWindowExecutionId] =
      ZIO.succeed(windowExecutionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest
  ) extends zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest.ReadOnly {
    override val windowExecutionId: MaintenanceWindowExecutionId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionId(impl.windowExecutionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CancelMaintenanceWindowExecutionRequest
  ): zio.aws.ssm.model.CancelMaintenanceWindowExecutionRequest.ReadOnly =
    new Wrapper(impl)
}
