package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceWindowsResponse(
    windowIdentities: Optional[
      Iterable[zio.aws.ssm.model.MaintenanceWindowIdentity]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse = {
    import DescribeMaintenanceWindowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse
      .builder()
      .optionallyWith(
        windowIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.windowIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.wrap(buildAwsValue())
}
object DescribeMaintenanceWindowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeMaintenanceWindowsResponse =
      zio.aws.ssm.model.DescribeMaintenanceWindowsResponse(
        windowIdentities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def windowIdentities
        : Optional[List[zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getWindowIdentities: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly
    ]] = AwsError.unwrapOptionField("windowIdentities", windowIdentities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly {
    override val windowIdentities
        : Optional[List[zio.aws.ssm.model.MaintenanceWindowIdentity.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowIdentities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.MaintenanceWindowIdentity.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowsResponse
  ): zio.aws.ssm.model.DescribeMaintenanceWindowsResponse.ReadOnly =
    new Wrapper(impl)
}
