package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DescribeEffectivePatchesForPatchBaselineResponse(
    effectivePatches: Optional[Iterable[zio.aws.ssm.model.EffectivePatch]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse = {
    import DescribeEffectivePatchesForPatchBaselineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse
      .builder()
      .optionallyWith(
        effectivePatches.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.effectivePatches)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly =
    zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse
      .wrap(buildAwsValue())
}
object DescribeEffectivePatchesForPatchBaselineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse =
      zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse(
        effectivePatches.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def effectivePatches
        : Optional[List[zio.aws.ssm.model.EffectivePatch.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEffectivePatches
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.EffectivePatch.ReadOnly]] =
      AwsError.unwrapOptionField("effectivePatches", effectivePatches)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse
  ) extends zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly {
    override val effectivePatches
        : Optional[List[zio.aws.ssm.model.EffectivePatch.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.effectivePatches())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.EffectivePatch.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse
  ): zio.aws.ssm.model.DescribeEffectivePatchesForPatchBaselineResponse.ReadOnly =
    new Wrapper(impl)
}
