package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  DocumentDisplayName,
  DocumentARN,
  DocumentVersion,
  DateTime,
  DocumentContent,
  DocumentStatusInformation,
  DocumentVersionName
}
import scala.jdk.CollectionConverters.*
final case class GetDocumentResponse(
    name: Optional[DocumentARN] = Optional.Absent,
    createdDate: Optional[DateTime] = Optional.Absent,
    displayName: Optional[DocumentDisplayName] = Optional.Absent,
    versionName: Optional[DocumentVersionName] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.DocumentStatus] = Optional.Absent,
    statusInformation: Optional[DocumentStatusInformation] = Optional.Absent,
    content: Optional[DocumentContent] = Optional.Absent,
    documentType: Optional[zio.aws.ssm.model.DocumentType] = Optional.Absent,
    documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      Optional.Absent,
    requires: Optional[Iterable[zio.aws.ssm.model.DocumentRequires]] =
      Optional.Absent,
    attachmentsContent: Optional[
      Iterable[zio.aws.ssm.model.AttachmentContent]
    ] = Optional.Absent,
    reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDocumentResponse = {
    import GetDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDocumentResponse
      .builder()
      .optionallyWith(
        name.map(value => DocumentARN.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        createdDate.map(value => DateTime.unwrap(value): Instant)
      )(_.createdDate)
      .optionallyWith(
        displayName.map(value =>
          DocumentDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusInformation.map(value =>
          DocumentStatusInformation.unwrap(value): java.lang.String
        )
      )(_.statusInformation)
      .optionallyWith(
        content.map(value => DocumentContent.unwrap(value): java.lang.String)
      )(_.content)
      .optionallyWith(documentType.map(value => value.unwrap))(_.documentType)
      .optionallyWith(documentFormat.map(value => value.unwrap))(
        _.documentFormat
      )
      .optionallyWith(
        requires.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.requires)
      .optionallyWith(
        attachmentsContent.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attachmentsContent)
      .optionallyWith(reviewStatus.map(value => value.unwrap))(_.reviewStatus)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetDocumentResponse.ReadOnly =
    zio.aws.ssm.model.GetDocumentResponse.wrap(buildAwsValue())
}
object GetDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetDocumentResponse =
      zio.aws.ssm.model.GetDocumentResponse(
        name.map(value => value),
        createdDate.map(value => value),
        displayName.map(value => value),
        versionName.map(value => value),
        documentVersion.map(value => value),
        status.map(value => value),
        statusInformation.map(value => value),
        content.map(value => value),
        documentType.map(value => value),
        documentFormat.map(value => value),
        requires.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        attachmentsContent.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        reviewStatus.map(value => value)
      )
    def name: Optional[DocumentARN]
    def createdDate: Optional[DateTime]
    def displayName: Optional[DocumentDisplayName]
    def versionName: Optional[DocumentVersionName]
    def documentVersion: Optional[DocumentVersion]
    def status: Optional[zio.aws.ssm.model.DocumentStatus]
    def statusInformation: Optional[DocumentStatusInformation]
    def content: Optional[DocumentContent]
    def documentType: Optional[zio.aws.ssm.model.DocumentType]
    def documentFormat: Optional[zio.aws.ssm.model.DocumentFormat]
    def requires: Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]]
    def attachmentsContent
        : Optional[List[zio.aws.ssm.model.AttachmentContent.ReadOnly]]
    def reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus]
    def getName: ZIO[Any, AwsError, DocumentARN] =
      AwsError.unwrapOptionField("name", name)
    def getCreatedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("createdDate", createdDate)
    def getDisplayName: ZIO[Any, AwsError, DocumentDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getStatus: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusInformation: ZIO[Any, AwsError, DocumentStatusInformation] =
      AwsError.unwrapOptionField("statusInformation", statusInformation)
    def getContent: ZIO[Any, AwsError, DocumentContent] =
      AwsError.unwrapOptionField("content", content)
    def getDocumentType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentType] =
      AwsError.unwrapOptionField("documentType", documentType)
    def getDocumentFormat
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentFormat] =
      AwsError.unwrapOptionField("documentFormat", documentFormat)
    def getRequires: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.DocumentRequires.ReadOnly
    ]] = AwsError.unwrapOptionField("requires", requires)
    def getAttachmentsContent: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AttachmentContent.ReadOnly
    ]] = AwsError.unwrapOptionField("attachmentsContent", attachmentsContent)
    def getReviewStatus: ZIO[Any, AwsError, zio.aws.ssm.model.ReviewStatus] =
      AwsError.unwrapOptionField("reviewStatus", reviewStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDocumentResponse
  ) extends zio.aws.ssm.model.GetDocumentResponse.ReadOnly {
    override val name: Optional[DocumentARN] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentARN(value))
    override val createdDate: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val displayName: Optional[DocumentDisplayName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.displayName())
        .map(value => zio.aws.ssm.model.primitives.DocumentDisplayName(value))
    override val versionName: Optional[DocumentVersionName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.versionName())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val status: Optional[zio.aws.ssm.model.DocumentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.ssm.model.DocumentStatus.wrap(value))
    override val statusInformation: Optional[DocumentStatusInformation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusInformation())
        .map(value =>
          zio.aws.ssm.model.primitives.DocumentStatusInformation(value)
        )
    override val content: Optional[DocumentContent] = zio.aws.core.internal
      .optionalFromNullable(impl.content())
      .map(value => zio.aws.ssm.model.primitives.DocumentContent(value))
    override val documentType: Optional[zio.aws.ssm.model.DocumentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentType())
        .map(value => zio.aws.ssm.model.DocumentType.wrap(value))
    override val documentFormat: Optional[zio.aws.ssm.model.DocumentFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentFormat())
        .map(value => zio.aws.ssm.model.DocumentFormat.wrap(value))
    override val requires
        : Optional[List[zio.aws.ssm.model.DocumentRequires.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.requires())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.DocumentRequires.wrap(item)
          }.toList
        )
    override val attachmentsContent
        : Optional[List[zio.aws.ssm.model.AttachmentContent.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.attachmentsContent())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AttachmentContent.wrap(item)
          }.toList
        )
    override val reviewStatus: Optional[zio.aws.ssm.model.ReviewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reviewStatus())
        .map(value => zio.aws.ssm.model.ReviewStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDocumentResponse
  ): zio.aws.ssm.model.GetDocumentResponse.ReadOnly = new Wrapper(impl)
}
