package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskParameterName,
  MaintenanceWindowTaskPriority,
  MaintenanceWindowId,
  MaintenanceWindowTaskArn,
  ServiceRole,
  ClientToken,
  MaxConcurrency,
  MaintenanceWindowName,
  MaxErrors,
  MaintenanceWindowDescription
}
import scala.jdk.CollectionConverters.*
final case class RegisterTaskWithMaintenanceWindowRequest(
    windowId: MaintenanceWindowId,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    taskArn: MaintenanceWindowTaskArn,
    serviceRoleArn: Optional[ServiceRole] = Optional.Absent,
    taskType: zio.aws.ssm.model.MaintenanceWindowTaskType,
    taskParameters: Optional[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
    ]] = Optional.Absent,
    taskInvocationParameters: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters
    ] = Optional.Absent,
    priority: Optional[MaintenanceWindowTaskPriority] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    loggingInfo: Optional[zio.aws.ssm.model.LoggingInfo] = Optional.Absent,
    name: Optional[MaintenanceWindowName] = Optional.Absent,
    description: Optional[MaintenanceWindowDescription] = Optional.Absent,
    clientToken: Optional[ClientToken] = Optional.Absent,
    cutoffBehavior: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = Optional.Absent,
    alarmConfiguration: Optional[zio.aws.ssm.model.AlarmConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest = {
    import RegisterTaskWithMaintenanceWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .taskArn(MaintenanceWindowTaskArn.unwrap(taskArn): java.lang.String)
      .optionallyWith(
        serviceRoleArn.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .taskType(taskType.unwrap)
      .optionallyWith(
        taskParameters.map(value =>
          value
            .map({ case (key, value) =>
              (MaintenanceWindowTaskParameterName.unwrap(
                key
              ): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.taskParameters)
      .optionallyWith(
        taskInvocationParameters.map(value => value.buildAwsValue())
      )(_.taskInvocationParameters)
      .optionallyWith(
        priority.map(value =>
          MaintenanceWindowTaskPriority.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(cutoffBehavior.map(value => value.unwrap))(
        _.cutoffBehavior
      )
      .optionallyWith(alarmConfiguration.map(value => value.buildAwsValue()))(
        _.alarmConfiguration
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest.ReadOnly =
    zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest
      .wrap(buildAwsValue())
}
object RegisterTaskWithMaintenanceWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest =
      zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest(
        windowId,
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskArn,
        serviceRoleArn.map(value => value),
        taskType,
        taskParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        taskInvocationParameters.map(value => value.asEditable),
        priority.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        loggingInfo.map(value => value.asEditable),
        name.map(value => value),
        description.map(value => value),
        clientToken.map(value => value),
        cutoffBehavior.map(value => value),
        alarmConfiguration.map(value => value.asEditable)
      )
    def windowId: MaintenanceWindowId
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def taskArn: MaintenanceWindowTaskArn
    def serviceRoleArn: Optional[ServiceRole]
    def taskType: zio.aws.ssm.model.MaintenanceWindowTaskType
    def taskParameters: Optional[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]
    def taskInvocationParameters: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ]
    def priority: Optional[MaintenanceWindowTaskPriority]
    def maxConcurrency: Optional[MaxConcurrency]
    def maxErrors: Optional[MaxErrors]
    def loggingInfo: Optional[zio.aws.ssm.model.LoggingInfo.ReadOnly]
    def name: Optional[MaintenanceWindowName]
    def description: Optional[MaintenanceWindowDescription]
    def clientToken: Optional[ClientToken]
    def cutoffBehavior
        : Optional[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior]
    def alarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly]
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTaskArn: ZIO[Any, Nothing, MaintenanceWindowTaskArn] =
      ZIO.succeed(taskArn)
    def getServiceRoleArn: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getTaskType
        : ZIO[Any, Nothing, zio.aws.ssm.model.MaintenanceWindowTaskType] =
      ZIO.succeed(taskType)
    def getTaskParameters: ZIO[Any, AwsError, Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("taskParameters", taskParameters)
    def getTaskInvocationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskInvocationParameters",
      taskInvocationParameters
    )
    def getPriority: ZIO[Any, AwsError, MaintenanceWindowTaskPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCutoffBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = AwsError.unwrapOptionField("cutoffBehavior", cutoffBehavior)
    def getAlarmConfiguration
        : ZIO[Any, AwsError, zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("alarmConfiguration", alarmConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest
  ) extends zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val taskArn: MaintenanceWindowTaskArn =
      zio.aws.ssm.model.primitives.MaintenanceWindowTaskArn(impl.taskArn())
    override val serviceRoleArn: Optional[ServiceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val taskType: zio.aws.ssm.model.MaintenanceWindowTaskType =
      zio.aws.ssm.model.MaintenanceWindowTaskType.wrap(impl.taskType())
    override val taskParameters: Optional[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.MaintenanceWindowTaskParameterName(
              key
            ) -> zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
              .wrap(value)
          })
          .toMap
      )
    override val taskInvocationParameters: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskInvocationParameters())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.wrap(value)
      )
    override val priority: Optional[MaintenanceWindowTaskPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskPriority(value)
        )
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val loggingInfo: Optional[zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingInfo())
        .map(value => zio.aws.ssm.model.LoggingInfo.wrap(value))
    override val name: Optional[MaintenanceWindowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Optional[MaintenanceWindowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
        )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.ssm.model.primitives.ClientToken(value))
    override val cutoffBehavior
        : Optional[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cutoffBehavior())
        .map(value =>
          zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior.wrap(value)
        )
    override val alarmConfiguration
        : Optional[zio.aws.ssm.model.AlarmConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.alarmConfiguration())
        .map(value => zio.aws.ssm.model.AlarmConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTaskWithMaintenanceWindowRequest
  ): zio.aws.ssm.model.RegisterTaskWithMaintenanceWindowRequest.ReadOnly =
    new Wrapper(impl)
}
