package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{TargetValue, TargetKey}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Target(
    key: Optional[TargetKey] = Optional.Absent,
    values: Optional[Iterable[TargetValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.Target = {
    import Target.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.Target
      .builder()
      .optionallyWith(
        key.map(value => TargetKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            TargetValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.Target.ReadOnly =
    zio.aws.ssm.model.Target.wrap(buildAwsValue())
}
object Target {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.Target] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.Target = zio.aws.ssm.model
      .Target(key.map(value => value), values.map(value => value))
    def key: Optional[TargetKey]
    def values: Optional[List[TargetValue]]
    def getKey: ZIO[Any, AwsError, TargetKey] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[TargetValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.Target
  ) extends zio.aws.ssm.model.Target.ReadOnly {
    override val key: Optional[TargetKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.ssm.model.primitives.TargetKey(value))
    override val values: Optional[List[TargetValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.TargetValue(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.Target
  ): zio.aws.ssm.model.Target.ReadOnly = new Wrapper(impl)
}
