package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  NextToken,
  MaintenanceWindowSearchMaxResults,
  MaintenanceWindowId
}
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceWindowScheduleRequest(
    windowId: Optional[MaintenanceWindowId] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    resourceType: Optional[zio.aws.ssm.model.MaintenanceWindowResourceType] =
      Optional.Absent,
    filters: Optional[Iterable[zio.aws.ssm.model.PatchOrchestratorFilter]] =
      Optional.Absent,
    maxResults: Optional[MaintenanceWindowSearchMaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest = {
    import DescribeMaintenanceWindowScheduleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(resourceType.map(value => value.unwrap))(_.resourceType)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          MaintenanceWindowSearchMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowScheduleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest =
      zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest(
        windowId.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        resourceType.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def windowId: Optional[MaintenanceWindowId]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def resourceType: Optional[zio.aws.ssm.model.MaintenanceWindowResourceType]
    def filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]]
    def maxResults: Optional[MaintenanceWindowSearchMaxResults]
    def nextToken: Optional[NextToken]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getResourceType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaintenanceWindowSearchMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest.ReadOnly {
    override val windowId: Optional[MaintenanceWindowId] = zio.aws.core.internal
      .optionalFromNullable(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val resourceType
        : Optional[zio.aws.ssm.model.MaintenanceWindowResourceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceType())
        .map(value =>
          zio.aws.ssm.model.MaintenanceWindowResourceType.wrap(value)
        )
    override val filters
        : Optional[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchOrchestratorFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaintenanceWindowSearchMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowSearchMaxResults(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowScheduleRequest
  ): zio.aws.ssm.model.DescribeMaintenanceWindowScheduleRequest.ReadOnly =
    new Wrapper(impl)
}
