package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.ssm.model.primitives.{
  ChangeRequestName,
  TargetMapValue,
  AutomationParameterValue,
  AutomationExecutionId,
  DocumentName,
  TargetMapKey,
  DocumentVersion,
  AutomationParameterKey,
  DateTime,
  MaxConcurrency,
  MaxErrors
}
import scala.jdk.CollectionConverters.*
final case class AutomationExecution(
    automationExecutionId: Optional[AutomationExecutionId] = Optional.Absent,
    documentName: Optional[DocumentName] = Optional.Absent,
    documentVersion: Optional[DocumentVersion] = Optional.Absent,
    executionStartTime: Optional[DateTime] = Optional.Absent,
    executionEndTime: Optional[DateTime] = Optional.Absent,
    automationExecutionStatus: Optional[
      zio.aws.ssm.model.AutomationExecutionStatus
    ] = Optional.Absent,
    stepExecutions: Optional[Iterable[zio.aws.ssm.model.StepExecution]] =
      Optional.Absent,
    stepExecutionsTruncated: Optional[Boolean] = Optional.Absent,
    parameters: Optional[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = Optional.Absent,
    outputs: Optional[
      Map[AutomationParameterKey, Iterable[AutomationParameterValue]]
    ] = Optional.Absent,
    failureMessage: Optional[String] = Optional.Absent,
    mode: Optional[zio.aws.ssm.model.ExecutionMode] = Optional.Absent,
    parentAutomationExecutionId: Optional[AutomationExecutionId] =
      Optional.Absent,
    executedBy: Optional[String] = Optional.Absent,
    currentStepName: Optional[String] = Optional.Absent,
    currentAction: Optional[String] = Optional.Absent,
    targetParameterName: Optional[AutomationParameterKey] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    targetMaps: Optional[
      Iterable[Map[TargetMapKey, Iterable[TargetMapValue]]]
    ] = Optional.Absent,
    resolvedTargets: Optional[zio.aws.ssm.model.ResolvedTargets] =
      Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    target: Optional[String] = Optional.Absent,
    targetLocations: Optional[Iterable[zio.aws.ssm.model.TargetLocation]] =
      Optional.Absent,
    progressCounters: Optional[zio.aws.ssm.model.ProgressCounters] =
      Optional.Absent,
    automationSubtype: Optional[zio.aws.ssm.model.AutomationSubtype] =
      Optional.Absent,
    scheduledTime: Optional[DateTime] = Optional.Absent,
    runbooks: Optional[Iterable[zio.aws.ssm.model.Runbook]] = Optional.Absent,
    opsItemId: Optional[String] = Optional.Absent,
    associationId: Optional[String] = Optional.Absent,
    changeRequestName: Optional[ChangeRequestName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AutomationExecution = {
    import AutomationExecution.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AutomationExecution
      .builder()
      .optionallyWith(
        automationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.automationExecutionId)
      .optionallyWith(
        documentName.map(value => DocumentName.unwrap(value): java.lang.String)
      )(_.documentName)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        executionStartTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionStartTime)
      .optionallyWith(
        executionEndTime.map(value => DateTime.unwrap(value): Instant)
      )(_.executionEndTime)
      .optionallyWith(automationExecutionStatus.map(value => value.unwrap))(
        _.automationExecutionStatus
      )
      .optionallyWith(
        stepExecutions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.stepExecutions)
      .optionallyWith(
        stepExecutionsTruncated.map(value => value: java.lang.Boolean)
      )(_.stepExecutionsTruncated)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        outputs.map(value =>
          value
            .map({ case (key, value) =>
              (AutomationParameterKey.unwrap(
                key
              ): java.lang.String) -> value.map { item =>
                AutomationParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.outputs)
      .optionallyWith(failureMessage.map(value => value: java.lang.String))(
        _.failureMessage
      )
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(
        parentAutomationExecutionId.map(value =>
          AutomationExecutionId.unwrap(value): java.lang.String
        )
      )(_.parentAutomationExecutionId)
      .optionallyWith(executedBy.map(value => value: java.lang.String))(
        _.executedBy
      )
      .optionallyWith(currentStepName.map(value => value: java.lang.String))(
        _.currentStepName
      )
      .optionallyWith(currentAction.map(value => value: java.lang.String))(
        _.currentAction
      )
      .optionallyWith(
        targetParameterName.map(value =>
          AutomationParameterKey.unwrap(value): java.lang.String
        )
      )(_.targetParameterName)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        targetMaps.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (TargetMapKey.unwrap(key): java.lang.String) -> value.map {
                  item =>
                    TargetMapValue.unwrap(item): java.lang.String
                }.asJavaCollection
              })
              .asJava
          }.asJavaCollection
        )
      )(_.targetMaps)
      .optionallyWith(resolvedTargets.map(value => value.buildAwsValue()))(
        _.resolvedTargets
      )
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(target.map(value => value: java.lang.String))(_.target)
      .optionallyWith(
        targetLocations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetLocations)
      .optionallyWith(progressCounters.map(value => value.buildAwsValue()))(
        _.progressCounters
      )
      .optionallyWith(automationSubtype.map(value => value.unwrap))(
        _.automationSubtype
      )
      .optionallyWith(
        scheduledTime.map(value => DateTime.unwrap(value): Instant)
      )(_.scheduledTime)
      .optionallyWith(
        runbooks.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runbooks)
      .optionallyWith(opsItemId.map(value => value: java.lang.String))(
        _.opsItemId
      )
      .optionallyWith(associationId.map(value => value: java.lang.String))(
        _.associationId
      )
      .optionallyWith(
        changeRequestName.map(value =>
          ChangeRequestName.unwrap(value): java.lang.String
        )
      )(_.changeRequestName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AutomationExecution.ReadOnly =
    zio.aws.ssm.model.AutomationExecution.wrap(buildAwsValue())
}
object AutomationExecution {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AutomationExecution
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AutomationExecution =
      zio.aws.ssm.model.AutomationExecution(
        automationExecutionId.map(value => value),
        documentName.map(value => value),
        documentVersion.map(value => value),
        executionStartTime.map(value => value),
        executionEndTime.map(value => value),
        automationExecutionStatus.map(value => value),
        stepExecutions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        stepExecutionsTruncated.map(value => value),
        parameters.map(value => value),
        outputs.map(value => value),
        failureMessage.map(value => value),
        mode.map(value => value),
        parentAutomationExecutionId.map(value => value),
        executedBy.map(value => value),
        currentStepName.map(value => value),
        currentAction.map(value => value),
        targetParameterName.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        targetMaps.map(value => value),
        resolvedTargets.map(value => value.asEditable),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        target.map(value => value),
        targetLocations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        progressCounters.map(value => value.asEditable),
        automationSubtype.map(value => value),
        scheduledTime.map(value => value),
        runbooks.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        opsItemId.map(value => value),
        associationId.map(value => value),
        changeRequestName.map(value => value)
      )
    def automationExecutionId: Optional[AutomationExecutionId]
    def documentName: Optional[DocumentName]
    def documentVersion: Optional[DocumentVersion]
    def executionStartTime: Optional[DateTime]
    def executionEndTime: Optional[DateTime]
    def automationExecutionStatus
        : Optional[zio.aws.ssm.model.AutomationExecutionStatus]
    def stepExecutions: Optional[List[zio.aws.ssm.model.StepExecution.ReadOnly]]
    def stepExecutionsTruncated: Optional[Boolean]
    def parameters
        : Optional[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def outputs
        : Optional[Map[AutomationParameterKey, List[AutomationParameterValue]]]
    def failureMessage: Optional[String]
    def mode: Optional[zio.aws.ssm.model.ExecutionMode]
    def parentAutomationExecutionId: Optional[AutomationExecutionId]
    def executedBy: Optional[String]
    def currentStepName: Optional[String]
    def currentAction: Optional[String]
    def targetParameterName: Optional[AutomationParameterKey]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def targetMaps: Optional[List[Map[TargetMapKey, List[TargetMapValue]]]]
    def resolvedTargets: Optional[zio.aws.ssm.model.ResolvedTargets.ReadOnly]
    def maxConcurrency: Optional[MaxConcurrency]
    def maxErrors: Optional[MaxErrors]
    def target: Optional[String]
    def targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]]
    def progressCounters: Optional[zio.aws.ssm.model.ProgressCounters.ReadOnly]
    def automationSubtype: Optional[zio.aws.ssm.model.AutomationSubtype]
    def scheduledTime: Optional[DateTime]
    def runbooks: Optional[List[zio.aws.ssm.model.Runbook.ReadOnly]]
    def opsItemId: Optional[String]
    def associationId: Optional[String]
    def changeRequestName: Optional[ChangeRequestName]
    def getAutomationExecutionId: ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField("automationExecutionId", automationExecutionId)
    def getDocumentName: ZIO[Any, AwsError, DocumentName] =
      AwsError.unwrapOptionField("documentName", documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getExecutionStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionStartTime", executionStartTime)
    def getExecutionEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("executionEndTime", executionEndTime)
    def getAutomationExecutionStatus
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationExecutionStatus] =
      AwsError.unwrapOptionField(
        "automationExecutionStatus",
        automationExecutionStatus
      )
    def getStepExecutions
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.StepExecution.ReadOnly]] =
      AwsError.unwrapOptionField("stepExecutions", stepExecutions)
    def getStepExecutionsTruncated: ZIO[Any, AwsError, Boolean] = AwsError
      .unwrapOptionField("stepExecutionsTruncated", stepExecutionsTruncated)
    def getParameters: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("parameters", parameters)
    def getOutputs: ZIO[Any, AwsError, Map[AutomationParameterKey, List[
      AutomationParameterValue
    ]]] = AwsError.unwrapOptionField("outputs", outputs)
    def getFailureMessage: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureMessage", failureMessage)
    def getMode: ZIO[Any, AwsError, zio.aws.ssm.model.ExecutionMode] =
      AwsError.unwrapOptionField("mode", mode)
    def getParentAutomationExecutionId
        : ZIO[Any, AwsError, AutomationExecutionId] =
      AwsError.unwrapOptionField(
        "parentAutomationExecutionId",
        parentAutomationExecutionId
      )
    def getExecutedBy: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("executedBy", executedBy)
    def getCurrentStepName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentStepName", currentStepName)
    def getCurrentAction: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("currentAction", currentAction)
    def getTargetParameterName: ZIO[Any, AwsError, AutomationParameterKey] =
      AwsError.unwrapOptionField("targetParameterName", targetParameterName)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTargetMaps
        : ZIO[Any, AwsError, List[Map[TargetMapKey, List[TargetMapValue]]]] =
      AwsError.unwrapOptionField("targetMaps", targetMaps)
    def getResolvedTargets
        : ZIO[Any, AwsError, zio.aws.ssm.model.ResolvedTargets.ReadOnly] =
      AwsError.unwrapOptionField("resolvedTargets", resolvedTargets)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getTarget: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("target", target)
    def getTargetLocations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      AwsError.unwrapOptionField("targetLocations", targetLocations)
    def getProgressCounters
        : ZIO[Any, AwsError, zio.aws.ssm.model.ProgressCounters.ReadOnly] =
      AwsError.unwrapOptionField("progressCounters", progressCounters)
    def getAutomationSubtype
        : ZIO[Any, AwsError, zio.aws.ssm.model.AutomationSubtype] =
      AwsError.unwrapOptionField("automationSubtype", automationSubtype)
    def getScheduledTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("scheduledTime", scheduledTime)
    def getRunbooks
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Runbook.ReadOnly]] =
      AwsError.unwrapOptionField("runbooks", runbooks)
    def getOpsItemId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("opsItemId", opsItemId)
    def getAssociationId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getChangeRequestName: ZIO[Any, AwsError, ChangeRequestName] =
      AwsError.unwrapOptionField("changeRequestName", changeRequestName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecution
  ) extends zio.aws.ssm.model.AutomationExecution.ReadOnly {
    override val automationExecutionId: Optional[AutomationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automationExecutionId())
        .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
    override val documentName: Optional[DocumentName] = zio.aws.core.internal
      .optionalFromNullable(impl.documentName())
      .map(value => zio.aws.ssm.model.primitives.DocumentName(value))
    override val documentVersion: Optional[DocumentVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documentVersion())
        .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val executionStartTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.executionStartTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val executionEndTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.executionEndTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val automationExecutionStatus
        : Optional[zio.aws.ssm.model.AutomationExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.automationExecutionStatus())
        .map(value => zio.aws.ssm.model.AutomationExecutionStatus.wrap(value))
    override val stepExecutions
        : Optional[List[zio.aws.ssm.model.StepExecution.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepExecutions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.StepExecution.wrap(item)
          }.toList
        )
    override val stepExecutionsTruncated: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stepExecutionsTruncated())
        .map(value => value: Boolean)
    override val parameters: Optional[
      Map[AutomationParameterKey, List[AutomationParameterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.parameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .AutomationParameterKey(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.AutomationParameterValue(item)
            }.toList
          })
          .toMap
      )
    override val outputs: Optional[
      Map[AutomationParameterKey, List[AutomationParameterValue]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputs())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives
              .AutomationParameterKey(key) -> value.asScala.map { item =>
              zio.aws.ssm.model.primitives.AutomationParameterValue(item)
            }.toList
          })
          .toMap
      )
    override val failureMessage: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureMessage())
      .map(value => value: String)
    override val mode: Optional[zio.aws.ssm.model.ExecutionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mode())
        .map(value => zio.aws.ssm.model.ExecutionMode.wrap(value))
    override val parentAutomationExecutionId: Optional[AutomationExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentAutomationExecutionId())
        .map(value => zio.aws.ssm.model.primitives.AutomationExecutionId(value))
    override val executedBy: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.executedBy())
      .map(value => value: String)
    override val currentStepName: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currentStepName())
      .map(value => value: String)
    override val currentAction: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.currentAction())
      .map(value => value: String)
    override val targetParameterName: Optional[AutomationParameterKey] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetParameterName())
        .map(value =>
          zio.aws.ssm.model.primitives.AutomationParameterKey(value)
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val targetMaps
        : Optional[List[Map[TargetMapKey, List[TargetMapValue]]]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetMaps())
        .map(value =>
          value.asScala.map { item =>
            item.asScala
              .map({ case (key, value) =>
                zio.aws.ssm.model.primitives
                  .TargetMapKey(key) -> value.asScala.map { item =>
                  zio.aws.ssm.model.primitives.TargetMapValue(item)
                }.toList
              })
              .toMap
          }.toList
        )
    override val resolvedTargets
        : Optional[zio.aws.ssm.model.ResolvedTargets.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resolvedTargets())
        .map(value => zio.aws.ssm.model.ResolvedTargets.wrap(value))
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val target: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => value: String)
    override val targetLocations
        : Optional[List[zio.aws.ssm.model.TargetLocation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.TargetLocation.wrap(item)
          }.toList
        )
    override val progressCounters
        : Optional[zio.aws.ssm.model.ProgressCounters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.progressCounters())
        .map(value => zio.aws.ssm.model.ProgressCounters.wrap(value))
    override val automationSubtype
        : Optional[zio.aws.ssm.model.AutomationSubtype] = zio.aws.core.internal
      .optionalFromNullable(impl.automationSubtype())
      .map(value => zio.aws.ssm.model.AutomationSubtype.wrap(value))
    override val scheduledTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val runbooks: Optional[List[zio.aws.ssm.model.Runbook.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runbooks())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Runbook.wrap(item)
          }.toList
        )
    override val opsItemId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.opsItemId())
      .map(value => value: String)
    override val associationId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.associationId())
      .map(value => value: String)
    override val changeRequestName: Optional[ChangeRequestName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeRequestName())
        .map(value => zio.aws.ssm.model.primitives.ChangeRequestName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AutomationExecution
  ): zio.aws.ssm.model.AutomationExecution.ReadOnly = new Wrapper(impl)
}
