package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.CommandFilterValue
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CommandFilter(
    key: zio.aws.ssm.model.CommandFilterKey,
    value: CommandFilterValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CommandFilter = {
    import CommandFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CommandFilter
      .builder()
      .key(key.unwrap)
      .value(CommandFilterValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CommandFilter.ReadOnly =
    zio.aws.ssm.model.CommandFilter.wrap(buildAwsValue())
}
object CommandFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.CommandFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CommandFilter =
      zio.aws.ssm.model.CommandFilter(key, value)
    def key: zio.aws.ssm.model.CommandFilterKey
    def value: CommandFilterValue
    def getKey: ZIO[Any, Nothing, zio.aws.ssm.model.CommandFilterKey] =
      ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, CommandFilterValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CommandFilter
  ) extends zio.aws.ssm.model.CommandFilter.ReadOnly {
    override val key: zio.aws.ssm.model.CommandFilterKey =
      zio.aws.ssm.model.CommandFilterKey.wrap(impl.key())
    override val value: CommandFilterValue =
      zio.aws.ssm.model.primitives.CommandFilterValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CommandFilter
  ): zio.aws.ssm.model.CommandFilter.ReadOnly = new Wrapper(impl)
}
