package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait OpsItemFilterOperator {
  def unwrap: software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator
}
object OpsItemFilterOperator {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator
  ): zio.aws.ssm.model.OpsItemFilterOperator = value match {
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.EQUAL =>
      val r = Equal
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.CONTAINS =>
      val r = Contains
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.GREATER_THAN =>
      val r = GreaterThan
      r
    case software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.LESS_THAN =>
      val r = LessThan
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.OpsItemFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.UNKNOWN_TO_SDK_VERSION
  }
  case object Equal extends zio.aws.ssm.model.OpsItemFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.EQUAL
  }
  case object Contains extends zio.aws.ssm.model.OpsItemFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.CONTAINS
  }
  case object GreaterThan extends zio.aws.ssm.model.OpsItemFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.GREATER_THAN
  }
  case object LessThan extends zio.aws.ssm.model.OpsItemFilterOperator {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator =
      software.amazon.awssdk.services.ssm.model.OpsItemFilterOperator.LESS_THAN
  }
}
