package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.InstancesCount
import scala.jdk.CollectionConverters.*
final case class DescribePatchGroupStateResponse(
    instances: Optional[zio.aws.ssm.model.primitives.Integer] = Optional.Absent,
    instancesWithInstalledPatches: Optional[
      zio.aws.ssm.model.primitives.Integer
    ] = Optional.Absent,
    instancesWithInstalledOtherPatches: Optional[
      zio.aws.ssm.model.primitives.Integer
    ] = Optional.Absent,
    instancesWithInstalledPendingRebootPatches: Optional[InstancesCount] =
      Optional.Absent,
    instancesWithInstalledRejectedPatches: Optional[InstancesCount] =
      Optional.Absent,
    instancesWithMissingPatches: Optional[
      zio.aws.ssm.model.primitives.Integer
    ] = Optional.Absent,
    instancesWithFailedPatches: Optional[zio.aws.ssm.model.primitives.Integer] =
      Optional.Absent,
    instancesWithNotApplicablePatches: Optional[
      zio.aws.ssm.model.primitives.Integer
    ] = Optional.Absent,
    instancesWithUnreportedNotApplicablePatches: Optional[
      zio.aws.ssm.model.primitives.Integer
    ] = Optional.Absent,
    instancesWithCriticalNonCompliantPatches: Optional[InstancesCount] =
      Optional.Absent,
    instancesWithSecurityNonCompliantPatches: Optional[InstancesCount] =
      Optional.Absent,
    instancesWithOtherNonCompliantPatches: Optional[InstancesCount] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse = {
    import DescribePatchGroupStateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
      .builder()
      .optionallyWith(instances.map(value => value: Integer))(_.instances)
      .optionallyWith(
        instancesWithInstalledPatches.map(value => value: Integer)
      )(_.instancesWithInstalledPatches)
      .optionallyWith(
        instancesWithInstalledOtherPatches.map(value => value: Integer)
      )(_.instancesWithInstalledOtherPatches)
      .optionallyWith(
        instancesWithInstalledPendingRebootPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithInstalledPendingRebootPatches)
      .optionallyWith(
        instancesWithInstalledRejectedPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithInstalledRejectedPatches)
      .optionallyWith(instancesWithMissingPatches.map(value => value: Integer))(
        _.instancesWithMissingPatches
      )
      .optionallyWith(instancesWithFailedPatches.map(value => value: Integer))(
        _.instancesWithFailedPatches
      )
      .optionallyWith(
        instancesWithNotApplicablePatches.map(value => value: Integer)
      )(_.instancesWithNotApplicablePatches)
      .optionallyWith(
        instancesWithUnreportedNotApplicablePatches.map(value => value: Integer)
      )(_.instancesWithUnreportedNotApplicablePatches)
      .optionallyWith(
        instancesWithCriticalNonCompliantPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithCriticalNonCompliantPatches)
      .optionallyWith(
        instancesWithSecurityNonCompliantPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithSecurityNonCompliantPatches)
      .optionallyWith(
        instancesWithOtherNonCompliantPatches.map(value =>
          InstancesCount.unwrap(value): Integer
        )
      )(_.instancesWithOtherNonCompliantPatches)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly =
    zio.aws.ssm.model.DescribePatchGroupStateResponse.wrap(buildAwsValue())
}
object DescribePatchGroupStateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchGroupStateResponse =
      zio.aws.ssm.model.DescribePatchGroupStateResponse(
        instances.map(value => value),
        instancesWithInstalledPatches.map(value => value),
        instancesWithInstalledOtherPatches.map(value => value),
        instancesWithInstalledPendingRebootPatches.map(value => value),
        instancesWithInstalledRejectedPatches.map(value => value),
        instancesWithMissingPatches.map(value => value),
        instancesWithFailedPatches.map(value => value),
        instancesWithNotApplicablePatches.map(value => value),
        instancesWithUnreportedNotApplicablePatches.map(value => value),
        instancesWithCriticalNonCompliantPatches.map(value => value),
        instancesWithSecurityNonCompliantPatches.map(value => value),
        instancesWithOtherNonCompliantPatches.map(value => value)
      )
    def instances: Optional[zio.aws.ssm.model.primitives.Integer]
    def instancesWithInstalledPatches
        : Optional[zio.aws.ssm.model.primitives.Integer]
    def instancesWithInstalledOtherPatches
        : Optional[zio.aws.ssm.model.primitives.Integer]
    def instancesWithInstalledPendingRebootPatches: Optional[InstancesCount]
    def instancesWithInstalledRejectedPatches: Optional[InstancesCount]
    def instancesWithMissingPatches
        : Optional[zio.aws.ssm.model.primitives.Integer]
    def instancesWithFailedPatches
        : Optional[zio.aws.ssm.model.primitives.Integer]
    def instancesWithNotApplicablePatches
        : Optional[zio.aws.ssm.model.primitives.Integer]
    def instancesWithUnreportedNotApplicablePatches
        : Optional[zio.aws.ssm.model.primitives.Integer]
    def instancesWithCriticalNonCompliantPatches: Optional[InstancesCount]
    def instancesWithSecurityNonCompliantPatches: Optional[InstancesCount]
    def instancesWithOtherNonCompliantPatches: Optional[InstancesCount]
    def getInstances: ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField("instances", instances)
    def getInstancesWithInstalledPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithInstalledPatches",
        instancesWithInstalledPatches
      )
    def getInstancesWithInstalledOtherPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithInstalledOtherPatches",
        instancesWithInstalledOtherPatches
      )
    def getInstancesWithInstalledPendingRebootPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithInstalledPendingRebootPatches",
      instancesWithInstalledPendingRebootPatches
    )
    def getInstancesWithInstalledRejectedPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithInstalledRejectedPatches",
      instancesWithInstalledRejectedPatches
    )
    def getInstancesWithMissingPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithMissingPatches",
        instancesWithMissingPatches
      )
    def getInstancesWithFailedPatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithFailedPatches",
        instancesWithFailedPatches
      )
    def getInstancesWithNotApplicablePatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithNotApplicablePatches",
        instancesWithNotApplicablePatches
      )
    def getInstancesWithUnreportedNotApplicablePatches
        : ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Integer] =
      AwsError.unwrapOptionField(
        "instancesWithUnreportedNotApplicablePatches",
        instancesWithUnreportedNotApplicablePatches
      )
    def getInstancesWithCriticalNonCompliantPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithCriticalNonCompliantPatches",
      instancesWithCriticalNonCompliantPatches
    )
    def getInstancesWithSecurityNonCompliantPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithSecurityNonCompliantPatches",
      instancesWithSecurityNonCompliantPatches
    )
    def getInstancesWithOtherNonCompliantPatches
        : ZIO[Any, AwsError, InstancesCount] = AwsError.unwrapOptionField(
      "instancesWithOtherNonCompliantPatches",
      instancesWithOtherNonCompliantPatches
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
  ) extends zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly {
    override val instances: Optional[zio.aws.ssm.model.primitives.Integer] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithInstalledPatches
        : Optional[zio.aws.ssm.model.primitives.Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithInstalledPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithInstalledOtherPatches
        : Optional[zio.aws.ssm.model.primitives.Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithInstalledOtherPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithInstalledPendingRebootPatches
        : Optional[InstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithInstalledPendingRebootPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithInstalledRejectedPatches
        : Optional[InstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithInstalledRejectedPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithMissingPatches
        : Optional[zio.aws.ssm.model.primitives.Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithMissingPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithFailedPatches
        : Optional[zio.aws.ssm.model.primitives.Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithFailedPatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithNotApplicablePatches
        : Optional[zio.aws.ssm.model.primitives.Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithNotApplicablePatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithUnreportedNotApplicablePatches
        : Optional[zio.aws.ssm.model.primitives.Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithUnreportedNotApplicablePatches())
      .map(value => value: zio.aws.ssm.model.primitives.Integer)
    override val instancesWithCriticalNonCompliantPatches
        : Optional[InstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithCriticalNonCompliantPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithSecurityNonCompliantPatches
        : Optional[InstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithSecurityNonCompliantPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
    override val instancesWithOtherNonCompliantPatches
        : Optional[InstancesCount] = zio.aws.core.internal
      .optionalFromNullable(impl.instancesWithOtherNonCompliantPatches())
      .map(value => zio.aws.ssm.model.primitives.InstancesCount(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchGroupStateResponse
  ): zio.aws.ssm.model.DescribePatchGroupStateResponse.ReadOnly = new Wrapper(
    impl
  )
}
