package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationComplianceSeverity {
  def unwrap
      : software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity
}
object AssociationComplianceSeverity {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity
  ): zio.aws.ssm.model.AssociationComplianceSeverity = value match {
    case software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.CRITICAL =>
      val r = CRITICAL
      r
    case software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.HIGH =>
      val r = HIGH
      r
    case software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.MEDIUM =>
      val r = MEDIUM
      r
    case software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.UNSPECIFIED =>
      val r = UNSPECIFIED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AssociationComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.UNKNOWN_TO_SDK_VERSION
  }
  case object CRITICAL extends zio.aws.ssm.model.AssociationComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.CRITICAL
  }
  case object HIGH extends zio.aws.ssm.model.AssociationComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.HIGH
  }
  case object MEDIUM extends zio.aws.ssm.model.AssociationComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.MEDIUM
  }
  case object LOW extends zio.aws.ssm.model.AssociationComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.LOW
  }
  case object UNSPECIFIED
      extends zio.aws.ssm.model.AssociationComplianceSeverity {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity =
      software.amazon.awssdk.services.ssm.model.AssociationComplianceSeverity.UNSPECIFIED
  }
}
