package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{ServiceSettingValue, ServiceSettingId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateServiceSettingRequest(
    settingId: ServiceSettingId,
    settingValue: ServiceSettingValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest = {
    import UpdateServiceSettingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest
      .builder()
      .settingId(ServiceSettingId.unwrap(settingId): java.lang.String)
      .settingValue(ServiceSettingValue.unwrap(settingValue): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UpdateServiceSettingRequest.ReadOnly =
    zio.aws.ssm.model.UpdateServiceSettingRequest.wrap(buildAwsValue())
}
object UpdateServiceSettingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateServiceSettingRequest =
      zio.aws.ssm.model.UpdateServiceSettingRequest(settingId, settingValue)
    def settingId: ServiceSettingId
    def settingValue: ServiceSettingValue
    def getSettingId: ZIO[Any, Nothing, ServiceSettingId] =
      ZIO.succeed(settingId)
    def getSettingValue: ZIO[Any, Nothing, ServiceSettingValue] =
      ZIO.succeed(settingValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest
  ) extends zio.aws.ssm.model.UpdateServiceSettingRequest.ReadOnly {
    override val settingId: ServiceSettingId =
      zio.aws.ssm.model.primitives.ServiceSettingId(impl.settingId())
    override val settingValue: ServiceSettingValue =
      zio.aws.ssm.model.primitives.ServiceSettingValue(impl.settingValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateServiceSettingRequest
  ): zio.aws.ssm.model.UpdateServiceSettingRequest.ReadOnly = new Wrapper(impl)
}
