package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.ParameterLabel
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UnlabelParameterVersionResponse(
    removedLabels: Optional[Iterable[ParameterLabel]] = Optional.Absent,
    invalidLabels: Optional[Iterable[ParameterLabel]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse = {
    import UnlabelParameterVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse
      .builder()
      .optionallyWith(
        removedLabels.map(value =>
          value.map { item =>
            ParameterLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.removedLabels)
      .optionallyWith(
        invalidLabels.map(value =>
          value.map { item =>
            ParameterLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.invalidLabels)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly =
    zio.aws.ssm.model.UnlabelParameterVersionResponse.wrap(buildAwsValue())
}
object UnlabelParameterVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UnlabelParameterVersionResponse =
      zio.aws.ssm.model.UnlabelParameterVersionResponse(
        removedLabels.map(value => value),
        invalidLabels.map(value => value)
      )
    def removedLabels: Optional[List[ParameterLabel]]
    def invalidLabels: Optional[List[ParameterLabel]]
    def getRemovedLabels: ZIO[Any, AwsError, List[ParameterLabel]] =
      AwsError.unwrapOptionField("removedLabels", removedLabels)
    def getInvalidLabels: ZIO[Any, AwsError, List[ParameterLabel]] =
      AwsError.unwrapOptionField("invalidLabels", invalidLabels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse
  ) extends zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly {
    override val removedLabels: Optional[List[ParameterLabel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.removedLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.ParameterLabel(item)
          }.toList
        )
    override val invalidLabels: Optional[List[ParameterLabel]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.invalidLabels())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.primitives.ParameterLabel(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UnlabelParameterVersionResponse
  ): zio.aws.ssm.model.UnlabelParameterVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
