package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.AttachmentName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AttachmentInformation(
    name: Optional[AttachmentName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AttachmentInformation = {
    import AttachmentInformation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AttachmentInformation
      .builder()
      .optionallyWith(
        name.map(value => AttachmentName.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AttachmentInformation.ReadOnly =
    zio.aws.ssm.model.AttachmentInformation.wrap(buildAwsValue())
}
object AttachmentInformation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AttachmentInformation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AttachmentInformation =
      zio.aws.ssm.model.AttachmentInformation(name.map(value => value))
    def name: Optional[AttachmentName]
    def getName: ZIO[Any, AwsError, AttachmentName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentInformation
  ) extends zio.aws.ssm.model.AttachmentInformation.ReadOnly {
    override val name: Optional[AttachmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.AttachmentName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AttachmentInformation
  ): zio.aws.ssm.model.AttachmentInformation.ReadOnly = new Wrapper(impl)
}
