package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait AssociationStatusName {
  def unwrap: software.amazon.awssdk.services.ssm.model.AssociationStatusName
}
object AssociationStatusName {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.AssociationStatusName
  ): zio.aws.ssm.model.AssociationStatusName = value match {
    case software.amazon.awssdk.services.ssm.model.AssociationStatusName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.AssociationStatusName.PENDING =>
      val r = Pending
      r
    case software.amazon.awssdk.services.ssm.model.AssociationStatusName.SUCCESS =>
      val r = Success
      r
    case software.amazon.awssdk.services.ssm.model.AssociationStatusName.FAILED =>
      val r = Failed
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.AssociationStatusName {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationStatusName =
      software.amazon.awssdk.services.ssm.model.AssociationStatusName.UNKNOWN_TO_SDK_VERSION
  }
  case object Pending extends zio.aws.ssm.model.AssociationStatusName {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationStatusName =
      software.amazon.awssdk.services.ssm.model.AssociationStatusName.PENDING
  }
  case object Success extends zio.aws.ssm.model.AssociationStatusName {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationStatusName =
      software.amazon.awssdk.services.ssm.model.AssociationStatusName.SUCCESS
  }
  case object Failed extends zio.aws.ssm.model.AssociationStatusName {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.AssociationStatusName =
      software.amazon.awssdk.services.ssm.model.AssociationStatusName.FAILED
  }
}
