package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetServiceSettingResponse(
    serviceSetting: Optional[zio.aws.ssm.model.ServiceSetting] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse = {
    import GetServiceSettingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse
      .builder()
      .optionallyWith(serviceSetting.map(value => value.buildAwsValue()))(
        _.serviceSetting
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly =
    zio.aws.ssm.model.GetServiceSettingResponse.wrap(buildAwsValue())
}
object GetServiceSettingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetServiceSettingResponse =
      zio.aws.ssm.model.GetServiceSettingResponse(
        serviceSetting.map(value => value.asEditable)
      )
    def serviceSetting: Optional[zio.aws.ssm.model.ServiceSetting.ReadOnly]
    def getServiceSetting
        : ZIO[Any, AwsError, zio.aws.ssm.model.ServiceSetting.ReadOnly] =
      AwsError.unwrapOptionField("serviceSetting", serviceSetting)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse
  ) extends zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly {
    override val serviceSetting
        : Optional[zio.aws.ssm.model.ServiceSetting.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serviceSetting())
        .map(value => zio.aws.ssm.model.ServiceSetting.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetServiceSettingResponse
  ): zio.aws.ssm.model.GetServiceSettingResponse.ReadOnly = new Wrapper(impl)
}
