package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.BaselineId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetPatchBaselineRequest(baselineId: BaselineId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest = {
    import GetPatchBaselineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest
      .builder()
      .baselineId(BaselineId.unwrap(baselineId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetPatchBaselineRequest.ReadOnly =
    zio.aws.ssm.model.GetPatchBaselineRequest.wrap(buildAwsValue())
}
object GetPatchBaselineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetPatchBaselineRequest =
      zio.aws.ssm.model.GetPatchBaselineRequest(baselineId)
    def baselineId: BaselineId
    def getBaselineId: ZIO[Any, Nothing, BaselineId] = ZIO.succeed(baselineId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest
  ) extends zio.aws.ssm.model.GetPatchBaselineRequest.ReadOnly {
    override val baselineId: BaselineId =
      zio.aws.ssm.model.primitives.BaselineId(impl.baselineId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetPatchBaselineRequest
  ): zio.aws.ssm.model.GetPatchBaselineRequest.ReadOnly = new Wrapper(impl)
}
