package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  GetInventorySchemaMaxResults,
  NextToken,
  AggregatorSchemaOnly,
  IsSubTypeSchema,
  InventoryItemTypeNameFilter
}
import scala.jdk.CollectionConverters.*
final case class GetInventorySchemaRequest(
    typeName: Optional[InventoryItemTypeNameFilter] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[GetInventorySchemaMaxResults] = Optional.Absent,
    aggregator: Optional[AggregatorSchemaOnly] = Optional.Absent,
    subType: Optional[IsSubTypeSchema] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest = {
    import GetInventorySchemaRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
      .builder()
      .optionallyWith(
        typeName.map(value =>
          InventoryItemTypeNameFilter.unwrap(value): java.lang.String
        )
      )(_.typeName)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value =>
          GetInventorySchemaMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        aggregator.map(value =>
          AggregatorSchemaOnly.unwrap(value): java.lang.Boolean
        )
      )(_.aggregator)
      .optionallyWith(
        subType.map(value => IsSubTypeSchema.unwrap(value): java.lang.Boolean)
      )(_.subType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.GetInventorySchemaRequest.ReadOnly =
    zio.aws.ssm.model.GetInventorySchemaRequest.wrap(buildAwsValue())
}
object GetInventorySchemaRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.GetInventorySchemaRequest =
      zio.aws.ssm.model.GetInventorySchemaRequest(
        typeName.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value),
        aggregator.map(value => value),
        subType.map(value => value)
      )
    def typeName: Optional[InventoryItemTypeNameFilter]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[GetInventorySchemaMaxResults]
    def aggregator: Optional[AggregatorSchemaOnly]
    def subType: Optional[IsSubTypeSchema]
    def getTypeName: ZIO[Any, AwsError, InventoryItemTypeNameFilter] =
      AwsError.unwrapOptionField("typeName", typeName)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, GetInventorySchemaMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getAggregator: ZIO[Any, AwsError, AggregatorSchemaOnly] =
      AwsError.unwrapOptionField("aggregator", aggregator)
    def getSubType: ZIO[Any, AwsError, IsSubTypeSchema] =
      AwsError.unwrapOptionField("subType", subType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
  ) extends zio.aws.ssm.model.GetInventorySchemaRequest.ReadOnly {
    override val typeName: Optional[InventoryItemTypeNameFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.typeName())
        .map(value =>
          zio.aws.ssm.model.primitives.InventoryItemTypeNameFilter(value)
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
    override val maxResults: Optional[GetInventorySchemaMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.ssm.model.primitives.GetInventorySchemaMaxResults(value)
        )
    override val aggregator: Optional[AggregatorSchemaOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.aggregator())
        .map(value => zio.aws.ssm.model.primitives.AggregatorSchemaOnly(value))
    override val subType: Optional[IsSubTypeSchema] = zio.aws.core.internal
      .optionalFromNullable(impl.subType())
      .map(value => zio.aws.ssm.model.primitives.IsSubTypeSchema(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetInventorySchemaRequest
  ): zio.aws.ssm.model.GetInventorySchemaRequest.ReadOnly = new Wrapper(impl)
}
