package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.SessionId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TerminateSessionRequest(sessionId: SessionId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.TerminateSessionRequest = {
    import TerminateSessionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.TerminateSessionRequest
      .builder()
      .sessionId(SessionId.unwrap(sessionId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.TerminateSessionRequest.ReadOnly =
    zio.aws.ssm.model.TerminateSessionRequest.wrap(buildAwsValue())
}
object TerminateSessionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.TerminateSessionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.TerminateSessionRequest =
      zio.aws.ssm.model.TerminateSessionRequest(sessionId)
    def sessionId: SessionId
    def getSessionId: ZIO[Any, Nothing, SessionId] = ZIO.succeed(sessionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.TerminateSessionRequest
  ) extends zio.aws.ssm.model.TerminateSessionRequest.ReadOnly {
    override val sessionId: SessionId =
      zio.aws.ssm.model.primitives.SessionId(impl.sessionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.TerminateSessionRequest
  ): zio.aws.ssm.model.TerminateSessionRequest.ReadOnly = new Wrapper(impl)
}
