package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowStringDateTime,
  MaintenanceWindowOffset,
  MaintenanceWindowTimezone,
  MaintenanceWindowCutoff,
  MaintenanceWindowSchedule,
  MaintenanceWindowDurationHours,
  ClientToken,
  MaintenanceWindowName,
  MaintenanceWindowAllowUnassociatedTargets,
  MaintenanceWindowDescription
}
import scala.jdk.CollectionConverters.*
final case class CreateMaintenanceWindowRequest(
    name: MaintenanceWindowName,
    description: Optional[MaintenanceWindowDescription] = Optional.Absent,
    startDate: Optional[MaintenanceWindowStringDateTime] = Optional.Absent,
    endDate: Optional[MaintenanceWindowStringDateTime] = Optional.Absent,
    schedule: MaintenanceWindowSchedule,
    scheduleTimezone: Optional[MaintenanceWindowTimezone] = Optional.Absent,
    scheduleOffset: Optional[MaintenanceWindowOffset] = Optional.Absent,
    duration: MaintenanceWindowDurationHours,
    cutoff: MaintenanceWindowCutoff,
    allowUnassociatedTargets: MaintenanceWindowAllowUnassociatedTargets,
    clientToken: Optional[ClientToken] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.ssm.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest = {
    import CreateMaintenanceWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest
      .builder()
      .name(MaintenanceWindowName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        startDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.startDate)
      .optionallyWith(
        endDate.map(value =>
          MaintenanceWindowStringDateTime.unwrap(value): java.lang.String
        )
      )(_.endDate)
      .schedule(MaintenanceWindowSchedule.unwrap(schedule): java.lang.String)
      .optionallyWith(
        scheduleTimezone.map(value =>
          MaintenanceWindowTimezone.unwrap(value): java.lang.String
        )
      )(_.scheduleTimezone)
      .optionallyWith(
        scheduleOffset.map(value =>
          MaintenanceWindowOffset.unwrap(value): Integer
        )
      )(_.scheduleOffset)
      .duration(MaintenanceWindowDurationHours.unwrap(duration): Integer)
      .cutoff(MaintenanceWindowCutoff.unwrap(cutoff): Integer)
      .allowUnassociatedTargets(
        MaintenanceWindowAllowUnassociatedTargets.unwrap(
          allowUnassociatedTargets
        ): java.lang.Boolean
      )
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateMaintenanceWindowRequest.ReadOnly =
    zio.aws.ssm.model.CreateMaintenanceWindowRequest.wrap(buildAwsValue())
}
object CreateMaintenanceWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateMaintenanceWindowRequest =
      zio.aws.ssm.model.CreateMaintenanceWindowRequest(
        name,
        description.map(value => value),
        startDate.map(value => value),
        endDate.map(value => value),
        schedule,
        scheduleTimezone.map(value => value),
        scheduleOffset.map(value => value),
        duration,
        cutoff,
        allowUnassociatedTargets,
        clientToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: MaintenanceWindowName
    def description: Optional[MaintenanceWindowDescription]
    def startDate: Optional[MaintenanceWindowStringDateTime]
    def endDate: Optional[MaintenanceWindowStringDateTime]
    def schedule: MaintenanceWindowSchedule
    def scheduleTimezone: Optional[MaintenanceWindowTimezone]
    def scheduleOffset: Optional[MaintenanceWindowOffset]
    def duration: MaintenanceWindowDurationHours
    def cutoff: MaintenanceWindowCutoff
    def allowUnassociatedTargets: MaintenanceWindowAllowUnassociatedTargets
    def clientToken: Optional[ClientToken]
    def tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, MaintenanceWindowName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStartDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getEndDate: ZIO[Any, AwsError, MaintenanceWindowStringDateTime] =
      AwsError.unwrapOptionField("endDate", endDate)
    def getSchedule: ZIO[Any, Nothing, MaintenanceWindowSchedule] =
      ZIO.succeed(schedule)
    def getScheduleTimezone: ZIO[Any, AwsError, MaintenanceWindowTimezone] =
      AwsError.unwrapOptionField("scheduleTimezone", scheduleTimezone)
    def getScheduleOffset: ZIO[Any, AwsError, MaintenanceWindowOffset] =
      AwsError.unwrapOptionField("scheduleOffset", scheduleOffset)
    def getDuration: ZIO[Any, Nothing, MaintenanceWindowDurationHours] =
      ZIO.succeed(duration)
    def getCutoff: ZIO[Any, Nothing, MaintenanceWindowCutoff] =
      ZIO.succeed(cutoff)
    def getAllowUnassociatedTargets
        : ZIO[Any, Nothing, MaintenanceWindowAllowUnassociatedTargets] =
      ZIO.succeed(allowUnassociatedTargets)
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.ssm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest
  ) extends zio.aws.ssm.model.CreateMaintenanceWindowRequest.ReadOnly {
    override val name: MaintenanceWindowName =
      zio.aws.ssm.model.primitives.MaintenanceWindowName(impl.name())
    override val description: Optional[MaintenanceWindowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
        )
    override val startDate: Optional[MaintenanceWindowStringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.startDate())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
        )
    override val endDate: Optional[MaintenanceWindowStringDateTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endDate())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowStringDateTime(value)
        )
    override val schedule: MaintenanceWindowSchedule =
      zio.aws.ssm.model.primitives.MaintenanceWindowSchedule(impl.schedule())
    override val scheduleTimezone: Optional[MaintenanceWindowTimezone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleTimezone())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTimezone(value)
        )
    override val scheduleOffset: Optional[MaintenanceWindowOffset] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleOffset())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowOffset(value)
        )
    override val duration: MaintenanceWindowDurationHours =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowDurationHours(impl.duration())
    override val cutoff: MaintenanceWindowCutoff =
      zio.aws.ssm.model.primitives.MaintenanceWindowCutoff(impl.cutoff())
    override val allowUnassociatedTargets
        : MaintenanceWindowAllowUnassociatedTargets =
      zio.aws.ssm.model.primitives.MaintenanceWindowAllowUnassociatedTargets(
        impl.allowUnassociatedTargets()
      )
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.ssm.model.primitives.ClientToken(value))
    override val tags: Optional[List[zio.aws.ssm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateMaintenanceWindowRequest
  ): zio.aws.ssm.model.CreateMaintenanceWindowRequest.ReadOnly = new Wrapper(
    impl
  )
}
