package zio.aws.ssm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskParameterName,
  MaintenanceWindowTaskPriority,
  MaintenanceWindowId,
  MaintenanceWindowTaskArn,
  MaintenanceWindowTaskId,
  ServiceRole,
  MaxConcurrency,
  MaintenanceWindowName,
  MaxErrors,
  MaintenanceWindowDescription
}
import scala.jdk.CollectionConverters.*
final case class UpdateMaintenanceWindowTaskResponse(
    windowId: Optional[MaintenanceWindowId] = Optional.Absent,
    windowTaskId: Optional[MaintenanceWindowTaskId] = Optional.Absent,
    targets: Optional[Iterable[zio.aws.ssm.model.Target]] = Optional.Absent,
    taskArn: Optional[MaintenanceWindowTaskArn] = Optional.Absent,
    serviceRoleArn: Optional[ServiceRole] = Optional.Absent,
    taskParameters: Optional[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
    ]] = Optional.Absent,
    taskInvocationParameters: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters
    ] = Optional.Absent,
    priority: Optional[MaintenanceWindowTaskPriority] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    loggingInfo: Optional[zio.aws.ssm.model.LoggingInfo] = Optional.Absent,
    name: Optional[MaintenanceWindowName] = Optional.Absent,
    description: Optional[MaintenanceWindowDescription] = Optional.Absent,
    cutoffBehavior: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse = {
    import UpdateMaintenanceWindowTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse
      .builder()
      .optionallyWith(
        windowId.map(value =>
          MaintenanceWindowId.unwrap(value): java.lang.String
        )
      )(_.windowId)
      .optionallyWith(
        windowTaskId.map(value =>
          MaintenanceWindowTaskId.unwrap(value): java.lang.String
        )
      )(_.windowTaskId)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .optionallyWith(
        taskArn.map(value =>
          MaintenanceWindowTaskArn.unwrap(value): java.lang.String
        )
      )(_.taskArn)
      .optionallyWith(
        serviceRoleArn.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(
        taskParameters.map(value =>
          value
            .map({ case (key, value) =>
              (MaintenanceWindowTaskParameterName.unwrap(
                key
              ): java.lang.String) -> value.buildAwsValue()
            })
            .asJava
        )
      )(_.taskParameters)
      .optionallyWith(
        taskInvocationParameters.map(value => value.buildAwsValue())
      )(_.taskInvocationParameters)
      .optionallyWith(
        priority.map(value =>
          MaintenanceWindowTaskPriority.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(loggingInfo.map(value => value.buildAwsValue()))(
        _.loggingInfo
      )
      .optionallyWith(
        name.map(value => MaintenanceWindowName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          MaintenanceWindowDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(cutoffBehavior.map(value => value.unwrap))(
        _.cutoffBehavior
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly =
    zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.wrap(buildAwsValue())
}
object UpdateMaintenanceWindowTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse =
      zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse(
        windowId.map(value => value),
        windowTaskId.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        taskArn.map(value => value),
        serviceRoleArn.map(value => value),
        taskParameters.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        taskInvocationParameters.map(value => value.asEditable),
        priority.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        loggingInfo.map(value => value.asEditable),
        name.map(value => value),
        description.map(value => value),
        cutoffBehavior.map(value => value)
      )
    def windowId: Optional[MaintenanceWindowId]
    def windowTaskId: Optional[MaintenanceWindowTaskId]
    def targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]]
    def taskArn: Optional[MaintenanceWindowTaskArn]
    def serviceRoleArn: Optional[ServiceRole]
    def taskParameters: Optional[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]
    def taskInvocationParameters: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ]
    def priority: Optional[MaintenanceWindowTaskPriority]
    def maxConcurrency: Optional[MaxConcurrency]
    def maxErrors: Optional[MaxErrors]
    def loggingInfo: Optional[zio.aws.ssm.model.LoggingInfo.ReadOnly]
    def name: Optional[MaintenanceWindowName]
    def description: Optional[MaintenanceWindowDescription]
    def cutoffBehavior
        : Optional[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior]
    def getWindowId: ZIO[Any, AwsError, MaintenanceWindowId] =
      AwsError.unwrapOptionField("windowId", windowId)
    def getWindowTaskId: ZIO[Any, AwsError, MaintenanceWindowTaskId] =
      AwsError.unwrapOptionField("windowTaskId", windowTaskId)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getTaskArn: ZIO[Any, AwsError, MaintenanceWindowTaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getServiceRoleArn: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getTaskParameters: ZIO[Any, AwsError, Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = AwsError.unwrapOptionField("taskParameters", taskParameters)
    def getTaskInvocationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "taskInvocationParameters",
      taskInvocationParameters
    )
    def getPriority: ZIO[Any, AwsError, MaintenanceWindowTaskPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getLoggingInfo
        : ZIO[Any, AwsError, zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      AwsError.unwrapOptionField("loggingInfo", loggingInfo)
    def getName: ZIO[Any, AwsError, MaintenanceWindowName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, MaintenanceWindowDescription] =
      AwsError.unwrapOptionField("description", description)
    def getCutoffBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior
    ] = AwsError.unwrapOptionField("cutoffBehavior", cutoffBehavior)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse
  ) extends zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly {
    override val windowId: Optional[MaintenanceWindowId] = zio.aws.core.internal
      .optionalFromNullable(impl.windowId())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowId(value))
    override val windowTaskId: Optional[MaintenanceWindowTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowTaskId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskId(value)
        )
    override val targets: Optional[List[zio.aws.ssm.model.Target.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val taskArn: Optional[MaintenanceWindowTaskArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskArn())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskArn(value)
        )
    override val serviceRoleArn: Optional[ServiceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRoleArn())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val taskParameters: Optional[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskParameters())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.MaintenanceWindowTaskParameterName(
              key
            ) -> zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
              .wrap(value)
          })
          .toMap
      )
    override val taskInvocationParameters: Optional[
      zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.taskInvocationParameters())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowTaskInvocationParameters.wrap(value)
      )
    override val priority: Optional[MaintenanceWindowTaskPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskPriority(value)
        )
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val loggingInfo: Optional[zio.aws.ssm.model.LoggingInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingInfo())
        .map(value => zio.aws.ssm.model.LoggingInfo.wrap(value))
    override val name: Optional[MaintenanceWindowName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.ssm.model.primitives.MaintenanceWindowName(value))
    override val description: Optional[MaintenanceWindowDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowDescription(value)
        )
    override val cutoffBehavior
        : Optional[zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cutoffBehavior())
        .map(value =>
          zio.aws.ssm.model.MaintenanceWindowTaskCutoffBehavior.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.UpdateMaintenanceWindowTaskResponse
  ): zio.aws.ssm.model.UpdateMaintenanceWindowTaskResponse.ReadOnly =
    new Wrapper(impl)
}
