package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentReviewAction {
  def unwrap: software.amazon.awssdk.services.ssm.model.DocumentReviewAction
}
object DocumentReviewAction {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.DocumentReviewAction
  ): zio.aws.ssm.model.DocumentReviewAction = value match {
    case software.amazon.awssdk.services.ssm.model.DocumentReviewAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.DocumentReviewAction.SEND_FOR_REVIEW =>
      val r = SendForReview
      r
    case software.amazon.awssdk.services.ssm.model.DocumentReviewAction.UPDATE_REVIEW =>
      val r = UpdateReview
      r
    case software.amazon.awssdk.services.ssm.model.DocumentReviewAction.APPROVE =>
      val r = Approve
      r
    case software.amazon.awssdk.services.ssm.model.DocumentReviewAction.REJECT =>
      val r = Reject
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.ssm.model.DocumentReviewAction {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentReviewAction =
      software.amazon.awssdk.services.ssm.model.DocumentReviewAction.UNKNOWN_TO_SDK_VERSION
  }
  case object SendForReview extends zio.aws.ssm.model.DocumentReviewAction {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentReviewAction =
      software.amazon.awssdk.services.ssm.model.DocumentReviewAction.SEND_FOR_REVIEW
  }
  case object UpdateReview extends zio.aws.ssm.model.DocumentReviewAction {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentReviewAction =
      software.amazon.awssdk.services.ssm.model.DocumentReviewAction.UPDATE_REVIEW
  }
  case object Approve extends zio.aws.ssm.model.DocumentReviewAction {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentReviewAction =
      software.amazon.awssdk.services.ssm.model.DocumentReviewAction.APPROVE
  }
  case object Reject extends zio.aws.ssm.model.DocumentReviewAction {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.DocumentReviewAction =
      software.amazon.awssdk.services.ssm.model.DocumentReviewAction.REJECT
  }
}
