package zio.aws.ssm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskParameterName,
  MaintenanceWindowTaskPriority,
  MaintenanceWindowExecutionId,
  MaintenanceWindowTaskArn,
  DateTime,
  MaintenanceWindowExecutionTaskId,
  ServiceRole,
  MaxConcurrency,
  MaxErrors,
  MaintenanceWindowExecutionStatusDetails
}
import scala.jdk.CollectionConverters.*
final case class GetMaintenanceWindowExecutionTaskResponse(
    windowExecutionId: Optional[MaintenanceWindowExecutionId] = Optional.Absent,
    taskExecutionId: Optional[MaintenanceWindowExecutionTaskId] =
      Optional.Absent,
    taskArn: Optional[MaintenanceWindowTaskArn] = Optional.Absent,
    serviceRole: Optional[ServiceRole] = Optional.Absent,
    `type`: Optional[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      Optional.Absent,
    taskParameters: Optional[Iterable[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
    ]]] = Optional.Absent,
    priority: Optional[MaintenanceWindowTaskPriority] = Optional.Absent,
    maxConcurrency: Optional[MaxConcurrency] = Optional.Absent,
    maxErrors: Optional[MaxErrors] = Optional.Absent,
    status: Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] =
      Optional.Absent,
    statusDetails: Optional[MaintenanceWindowExecutionStatusDetails] =
      Optional.Absent,
    startTime: Optional[DateTime] = Optional.Absent,
    endTime: Optional[DateTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = {
    import GetMaintenanceWindowExecutionTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
      .builder()
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .optionallyWith(
        taskExecutionId.map(value =>
          MaintenanceWindowExecutionTaskId.unwrap(value): java.lang.String
        )
      )(_.taskExecutionId)
      .optionallyWith(
        taskArn.map(value =>
          MaintenanceWindowTaskArn.unwrap(value): java.lang.String
        )
      )(_.taskArn)
      .optionallyWith(
        serviceRole.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        taskParameters.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (MaintenanceWindowTaskParameterName.unwrap(
                  key
                ): java.lang.String) -> value.buildAwsValue()
              })
              .asJava
          }.asJavaCollection
        )
      )(_.taskParameters)
      .optionallyWith(
        priority.map(value =>
          MaintenanceWindowTaskPriority.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          MaintenanceWindowExecutionStatusDetails.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse
      .wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse =
      zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse(
        windowExecutionId.map(value => value),
        taskExecutionId.map(value => value),
        taskArn.map(value => value),
        serviceRole.map(value => value),
        `type`.map(value => value),
        taskParameters.map(value =>
          value.map { item =>
            item.map({ case (key, value) =>
              key -> value.asEditable
            })
          }
        ),
        priority.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def windowExecutionId: Optional[MaintenanceWindowExecutionId]
    def taskExecutionId: Optional[MaintenanceWindowExecutionTaskId]
    def taskArn: Optional[MaintenanceWindowTaskArn]
    def serviceRole: Optional[ServiceRole]
    def `type`: Optional[zio.aws.ssm.model.MaintenanceWindowTaskType]
    def taskParameters: Optional[List[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]]
    def priority: Optional[MaintenanceWindowTaskPriority]
    def maxConcurrency: Optional[MaxConcurrency]
    def maxErrors: Optional[MaxErrors]
    def status: Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus]
    def statusDetails: Optional[MaintenanceWindowExecutionStatusDetails]
    def startTime: Optional[DateTime]
    def endTime: Optional[DateTime]
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
    def getTaskExecutionId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskId] =
      AwsError.unwrapOptionField("taskExecutionId", taskExecutionId)
    def getTaskArn: ZIO[Any, AwsError, MaintenanceWindowTaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getServiceRole: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTaskType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTaskParameters: ZIO[Any, AwsError, List[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]] = AwsError.unwrapOptionField("taskParameters", taskParameters)
    def getPriority: ZIO[Any, AwsError, MaintenanceWindowTaskPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails
        : ZIO[Any, AwsError, MaintenanceWindowExecutionStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly {
    override val windowExecutionId: Optional[MaintenanceWindowExecutionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.windowExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
        )
    override val taskExecutionId: Optional[MaintenanceWindowExecutionTaskId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionTaskId(value)
        )
    override val taskArn: Optional[MaintenanceWindowTaskArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskArn())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskArn(value)
        )
    override val serviceRole: Optional[ServiceRole] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceRole())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val `type`: Optional[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.ssm.model.MaintenanceWindowTaskType.wrap(value))
    override val taskParameters: Optional[List[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]] = zio.aws.core.internal
      .optionalFromNullable(impl.taskParameters())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives.MaintenanceWindowTaskParameterName(
                key
              ) -> zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
                .wrap(value)
            })
            .toMap
        }.toList
      )
    override val priority: Optional[MaintenanceWindowTaskPriority] =
      zio.aws.core.internal
        .optionalFromNullable(impl.priority())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowTaskPriority(value)
        )
    override val maxConcurrency: Optional[MaxConcurrency] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxConcurrency())
        .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Optional[MaxErrors] = zio.aws.core.internal
      .optionalFromNullable(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val status
        : Optional[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.ssm.model.MaintenanceWindowExecutionStatus.wrap(value)
        )
    override val statusDetails
        : Optional[MaintenanceWindowExecutionStatusDetails] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDetails())
        .map(value =>
          zio.aws.ssm.model.primitives
            .MaintenanceWindowExecutionStatusDetails(value)
        )
    override val startTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endTime: Optional[DateTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly =
    new Wrapper(impl)
}
