package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  ResourceDataSyncEnableAllOpsDataSources,
  ResourceDataSyncIncludeFutureRegions,
  ResourceDataSyncSourceRegion,
  ResourceDataSyncSourceType
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ResourceDataSyncSource(
    sourceType: ResourceDataSyncSourceType,
    awsOrganizationsSource: Optional[
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource
    ] = Optional.Absent,
    sourceRegions: Iterable[ResourceDataSyncSourceRegion],
    includeFutureRegions: Optional[ResourceDataSyncIncludeFutureRegions] =
      Optional.Absent,
    enableAllOpsDataSources: Optional[ResourceDataSyncEnableAllOpsDataSources] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ResourceDataSyncSource = {
    import ResourceDataSyncSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncSource
      .builder()
      .sourceType(
        ResourceDataSyncSourceType.unwrap(sourceType): java.lang.String
      )
      .optionallyWith(
        awsOrganizationsSource.map(value => value.buildAwsValue())
      )(_.awsOrganizationsSource)
      .sourceRegions(sourceRegions.map { item =>
        ResourceDataSyncSourceRegion.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        includeFutureRegions.map(value =>
          ResourceDataSyncIncludeFutureRegions.unwrap(value): java.lang.Boolean
        )
      )(_.includeFutureRegions)
      .optionallyWith(
        enableAllOpsDataSources.map(value =>
          ResourceDataSyncEnableAllOpsDataSources.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.enableAllOpsDataSources)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly =
    zio.aws.ssm.model.ResourceDataSyncSource.wrap(buildAwsValue())
}
object ResourceDataSyncSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ResourceDataSyncSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ResourceDataSyncSource =
      zio.aws.ssm.model.ResourceDataSyncSource(
        sourceType,
        awsOrganizationsSource.map(value => value.asEditable),
        sourceRegions,
        includeFutureRegions.map(value => value),
        enableAllOpsDataSources.map(value => value)
      )
    def sourceType: ResourceDataSyncSourceType
    def awsOrganizationsSource: Optional[
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly
    ]
    def sourceRegions: List[ResourceDataSyncSourceRegion]
    def includeFutureRegions: Optional[ResourceDataSyncIncludeFutureRegions]
    def enableAllOpsDataSources
        : Optional[ResourceDataSyncEnableAllOpsDataSources]
    def getSourceType: ZIO[Any, Nothing, ResourceDataSyncSourceType] =
      ZIO.succeed(sourceType)
    def getAwsOrganizationsSource: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly
    ] = AwsError.unwrapOptionField(
      "awsOrganizationsSource",
      awsOrganizationsSource
    )
    def getSourceRegions
        : ZIO[Any, Nothing, List[ResourceDataSyncSourceRegion]] =
      ZIO.succeed(sourceRegions)
    def getIncludeFutureRegions
        : ZIO[Any, AwsError, ResourceDataSyncIncludeFutureRegions] =
      AwsError.unwrapOptionField("includeFutureRegions", includeFutureRegions)
    def getEnableAllOpsDataSources
        : ZIO[Any, AwsError, ResourceDataSyncEnableAllOpsDataSources] = AwsError
      .unwrapOptionField("enableAllOpsDataSources", enableAllOpsDataSources)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncSource
  ) extends zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly {
    override val sourceType: ResourceDataSyncSourceType =
      zio.aws.ssm.model.primitives.ResourceDataSyncSourceType(impl.sourceType())
    override val awsOrganizationsSource: Optional[
      zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.awsOrganizationsSource())
      .map(value =>
        zio.aws.ssm.model.ResourceDataSyncAwsOrganizationsSource.wrap(value)
      )
    override val sourceRegions: List[ResourceDataSyncSourceRegion] = impl
      .sourceRegions()
      .asScala
      .map { item =>
        zio.aws.ssm.model.primitives.ResourceDataSyncSourceRegion(item)
      }
      .toList
    override val includeFutureRegions
        : Optional[ResourceDataSyncIncludeFutureRegions] = zio.aws.core.internal
      .optionalFromNullable(impl.includeFutureRegions())
      .map(value =>
        zio.aws.ssm.model.primitives.ResourceDataSyncIncludeFutureRegions(value)
      )
    override val enableAllOpsDataSources
        : Optional[ResourceDataSyncEnableAllOpsDataSources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enableAllOpsDataSources())
        .map(value =>
          zio.aws.ssm.model.primitives
            .ResourceDataSyncEnableAllOpsDataSources(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ResourceDataSyncSource
  ): zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly = new Wrapper(impl)
}
