package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListAssociationsResponse(
    associations: Optional[Iterable[zio.aws.ssm.model.Association]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListAssociationsResponse = {
    import ListAssociationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListAssociationsResponse
      .builder()
      .optionallyWith(
        associations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.associations)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListAssociationsResponse.ReadOnly =
    zio.aws.ssm.model.ListAssociationsResponse.wrap(buildAwsValue())
}
object ListAssociationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListAssociationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListAssociationsResponse =
      zio.aws.ssm.model.ListAssociationsResponse(
        associations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def associations: Optional[List[zio.aws.ssm.model.Association.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getAssociations
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Association.ReadOnly]] =
      AwsError.unwrapOptionField("associations", associations)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationsResponse
  ) extends zio.aws.ssm.model.ListAssociationsResponse.ReadOnly {
    override val associations
        : Optional[List[zio.aws.ssm.model.Association.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.associations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Association.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListAssociationsResponse
  ): zio.aws.ssm.model.ListAssociationsResponse.ReadOnly = new Wrapper(impl)
}
