package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.MaintenanceWindowTargetId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class RegisterTargetWithMaintenanceWindowResponse(
    windowTargetId: Option[MaintenanceWindowTargetId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse = {
    import RegisterTargetWithMaintenanceWindowResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
      .builder()
      .optionallyWith(
        windowTargetId.map(value =>
          MaintenanceWindowTargetId.unwrap(value): java.lang.String
        )
      )(_.windowTargetId)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly =
    zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse
      .wrap(buildAwsValue())
}
object RegisterTargetWithMaintenanceWindowResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse =
      zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse(
        windowTargetId.map(value => value)
      )
    def windowTargetId: Option[MaintenanceWindowTargetId]
    def getWindowTargetId: ZIO[Any, AwsError, MaintenanceWindowTargetId] =
      AwsError.unwrapOptionField("windowTargetId", windowTargetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
  ) extends zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly {
    override val windowTargetId: Option[MaintenanceWindowTargetId] = scala
      .Option(impl.windowTargetId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTargetId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.RegisterTargetWithMaintenanceWindowResponse
  ): zio.aws.ssm.model.RegisterTargetWithMaintenanceWindowResponse.ReadOnly =
    new Wrapper(impl)
}
