package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  PSParameterName,
  PSParameterVersion,
  ParameterDescription,
  DateTime,
  AllowedPattern,
  PSParameterValue,
  ParameterKeyId,
  ParameterDataType,
  ParameterLabel
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class ParameterHistory(
    name: Option[PSParameterName] = None,
    `type`: Option[zio.aws.ssm.model.ParameterType] = None,
    keyId: Option[ParameterKeyId] = None,
    lastModifiedDate: Option[DateTime] = None,
    lastModifiedUser: Option[String] = None,
    description: Option[ParameterDescription] = None,
    value: Option[PSParameterValue] = None,
    allowedPattern: Option[AllowedPattern] = None,
    version: Option[PSParameterVersion] = None,
    labels: Option[Iterable[ParameterLabel]] = None,
    tier: Option[zio.aws.ssm.model.ParameterTier] = None,
    policies: Option[Iterable[zio.aws.ssm.model.ParameterInlinePolicy]] = None,
    dataType: Option[ParameterDataType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ParameterHistory = {
    import ParameterHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ParameterHistory
      .builder()
      .optionallyWith(
        name.map(value => PSParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        keyId.map(value => ParameterKeyId.unwrap(value): java.lang.String)
      )(_.keyId)
      .optionallyWith(
        lastModifiedDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(lastModifiedUser.map(value => value: java.lang.String))(
        _.lastModifiedUser
      )
      .optionallyWith(
        description.map(value =>
          ParameterDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        value.map(value => PSParameterValue.unwrap(value): java.lang.String)
      )(_.value)
      .optionallyWith(
        allowedPattern.map(value =>
          AllowedPattern.unwrap(value): java.lang.String
        )
      )(_.allowedPattern)
      .optionallyWith(
        version.map(value => PSParameterVersion.unwrap(value): java.lang.Long)
      )(_.version)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            ParameterLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .optionallyWith(tier.map(value => value.unwrap))(_.tier)
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .optionallyWith(
        dataType.map(value => ParameterDataType.unwrap(value): java.lang.String)
      )(_.dataType)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ParameterHistory.ReadOnly =
    zio.aws.ssm.model.ParameterHistory.wrap(buildAwsValue())
}
object ParameterHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ParameterHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ParameterHistory =
      zio.aws.ssm.model.ParameterHistory(
        name.map(value => value),
        `type`.map(value => value),
        keyId.map(value => value),
        lastModifiedDate.map(value => value),
        lastModifiedUser.map(value => value),
        description.map(value => value),
        value.map(value => value),
        allowedPattern.map(value => value),
        version.map(value => value),
        labels.map(value => value),
        tier.map(value => value),
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataType.map(value => value)
      )
    def name: Option[PSParameterName]
    def `type`: Option[zio.aws.ssm.model.ParameterType]
    def keyId: Option[ParameterKeyId]
    def lastModifiedDate: Option[DateTime]
    def lastModifiedUser: Option[String]
    def description: Option[ParameterDescription]
    def value: Option[PSParameterValue]
    def allowedPattern: Option[AllowedPattern]
    def version: Option[PSParameterVersion]
    def labels: Option[List[ParameterLabel]]
    def tier: Option[zio.aws.ssm.model.ParameterTier]
    def policies: Option[List[zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly]]
    def dataType: Option[ParameterDataType]
    def getName: ZIO[Any, AwsError, PSParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getKeyId: ZIO[Any, AwsError, ParameterKeyId] =
      AwsError.unwrapOptionField("keyId", keyId)
    def getLastModifiedDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedUser: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("lastModifiedUser", lastModifiedUser)
    def getDescription: ZIO[Any, AwsError, ParameterDescription] =
      AwsError.unwrapOptionField("description", description)
    def getValue: ZIO[Any, AwsError, PSParameterValue] =
      AwsError.unwrapOptionField("value", value)
    def getAllowedPattern: ZIO[Any, AwsError, AllowedPattern] =
      AwsError.unwrapOptionField("allowedPattern", allowedPattern)
    def getVersion: ZIO[Any, AwsError, PSParameterVersion] =
      AwsError.unwrapOptionField("version", version)
    def getLabels: ZIO[Any, AwsError, List[ParameterLabel]] =
      AwsError.unwrapOptionField("labels", labels)
    def getTier: ZIO[Any, AwsError, zio.aws.ssm.model.ParameterTier] =
      AwsError.unwrapOptionField("tier", tier)
    def getPolicies: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policies)
    def getDataType: ZIO[Any, AwsError, ParameterDataType] =
      AwsError.unwrapOptionField("dataType", dataType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ParameterHistory
  ) extends zio.aws.ssm.model.ParameterHistory.ReadOnly {
    override val name: Option[PSParameterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.PSParameterName(value))
    override val `type`: Option[zio.aws.ssm.model.ParameterType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ssm.model.ParameterType.wrap(value))
    override val keyId: Option[ParameterKeyId] = scala
      .Option(impl.keyId())
      .map(value => zio.aws.ssm.model.primitives.ParameterKeyId(value))
    override val lastModifiedDate: Option[DateTime] = scala
      .Option(impl.lastModifiedDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val lastModifiedUser: Option[String] =
      scala.Option(impl.lastModifiedUser()).map(value => value: String)
    override val description: Option[ParameterDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.ssm.model.primitives.ParameterDescription(value))
    override val value: Option[PSParameterValue] = scala
      .Option(impl.value())
      .map(value => zio.aws.ssm.model.primitives.PSParameterValue(value))
    override val allowedPattern: Option[AllowedPattern] = scala
      .Option(impl.allowedPattern())
      .map(value => zio.aws.ssm.model.primitives.AllowedPattern(value))
    override val version: Option[PSParameterVersion] = scala
      .Option(impl.version())
      .map(value => zio.aws.ssm.model.primitives.PSParameterVersion(value))
    override val labels: Option[List[ParameterLabel]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.ParameterLabel(item)
        }.toList
      )
    override val tier: Option[zio.aws.ssm.model.ParameterTier] = scala
      .Option(impl.tier())
      .map(value => zio.aws.ssm.model.ParameterTier.wrap(value))
    override val policies
        : Option[List[zio.aws.ssm.model.ParameterInlinePolicy.ReadOnly]] = scala
      .Option(impl.policies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ParameterInlinePolicy.wrap(item)
        }.toList
      )
    override val dataType: Option[ParameterDataType] = scala
      .Option(impl.dataType())
      .map(value => zio.aws.ssm.model.primitives.ParameterDataType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ParameterHistory
  ): zio.aws.ssm.model.ParameterHistory.ReadOnly = new Wrapper(impl)
}
