package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentParameterDefaultValue,
  DocumentParameterDescrption,
  DocumentParameterName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DocumentParameter(
    name: Option[DocumentParameterName] = None,
    `type`: Option[zio.aws.ssm.model.DocumentParameterType] = None,
    description: Option[DocumentParameterDescrption] = None,
    defaultValue: Option[DocumentParameterDefaultValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DocumentParameter = {
    import DocumentParameter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DocumentParameter
      .builder()
      .optionallyWith(
        name.map(value => DocumentParameterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        description.map(value =>
          DocumentParameterDescrption.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        defaultValue.map(value =>
          DocumentParameterDefaultValue.unwrap(value): java.lang.String
        )
      )(_.defaultValue)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DocumentParameter.ReadOnly =
    zio.aws.ssm.model.DocumentParameter.wrap(buildAwsValue())
}
object DocumentParameter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DocumentParameter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DocumentParameter =
      zio.aws.ssm.model.DocumentParameter(
        name.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        defaultValue.map(value => value)
      )
    def name: Option[DocumentParameterName]
    def `type`: Option[zio.aws.ssm.model.DocumentParameterType]
    def description: Option[DocumentParameterDescrption]
    def defaultValue: Option[DocumentParameterDefaultValue]
    def getName: ZIO[Any, AwsError, DocumentParameterName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.ssm.model.DocumentParameterType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, DocumentParameterDescrption] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultValue: ZIO[Any, AwsError, DocumentParameterDefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DocumentParameter
  ) extends zio.aws.ssm.model.DocumentParameter.ReadOnly {
    override val name: Option[DocumentParameterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.ssm.model.primitives.DocumentParameterName(value))
    override val `type`: Option[zio.aws.ssm.model.DocumentParameterType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.ssm.model.DocumentParameterType.wrap(value))
    override val description: Option[DocumentParameterDescrption] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.ssm.model.primitives.DocumentParameterDescrption(value)
      )
    override val defaultValue: Option[DocumentParameterDefaultValue] = scala
      .Option(impl.defaultValue())
      .map(value =>
        zio.aws.ssm.model.primitives.DocumentParameterDefaultValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DocumentParameter
  ): zio.aws.ssm.model.DocumentParameter.ReadOnly = new Wrapper(impl)
}
