package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePatchBaselinesResponse(
    baselineIdentities: Option[
      Iterable[zio.aws.ssm.model.PatchBaselineIdentity]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse = {
    import DescribePatchBaselinesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse
      .builder()
      .optionallyWith(
        baselineIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.baselineIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly =
    zio.aws.ssm.model.DescribePatchBaselinesResponse.wrap(buildAwsValue())
}
object DescribePatchBaselinesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchBaselinesResponse =
      zio.aws.ssm.model.DescribePatchBaselinesResponse(
        baselineIdentities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def baselineIdentities
        : Option[List[zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly]]
    def nextToken: Option[NextToken]
    def getBaselineIdentities: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly
    ]] = AwsError.unwrapOptionField("baselineIdentities", baselineIdentities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse
  ) extends zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly {
    override val baselineIdentities
        : Option[List[zio.aws.ssm.model.PatchBaselineIdentity.ReadOnly]] = scala
      .Option(impl.baselineIdentities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.PatchBaselineIdentity.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesResponse
  ): zio.aws.ssm.model.DescribePatchBaselinesResponse.ReadOnly = new Wrapper(
    impl
  )
}
