package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, MaxResults, AssociationId}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeAssociationExecutionsRequest(
    associationId: AssociationId,
    filters: Option[Iterable[zio.aws.ssm.model.AssociationExecutionFilter]] =
      None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest = {
    import DescribeAssociationExecutionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest
      .builder()
      .associationId(AssociationId.unwrap(associationId): java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeAssociationExecutionsRequest.ReadOnly =
    zio.aws.ssm.model.DescribeAssociationExecutionsRequest.wrap(buildAwsValue())
}
object DescribeAssociationExecutionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribeAssociationExecutionsRequest =
      zio.aws.ssm.model.DescribeAssociationExecutionsRequest(
        associationId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def associationId: AssociationId
    def filters
        : Option[List[zio.aws.ssm.model.AssociationExecutionFilter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getAssociationId: ZIO[Any, Nothing, AssociationId] =
      ZIO.succeed(associationId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AssociationExecutionFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest
  ) extends zio.aws.ssm.model.DescribeAssociationExecutionsRequest.ReadOnly {
    override val associationId: AssociationId =
      zio.aws.ssm.model.primitives.AssociationId(impl.associationId())
    override val filters
        : Option[List[zio.aws.ssm.model.AssociationExecutionFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AssociationExecutionFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeAssociationExecutionsRequest
  ): zio.aws.ssm.model.DescribeAssociationExecutionsRequest.ReadOnly =
    new Wrapper(impl)
}
