package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  AssociationId,
  StatusName,
  AssociationExecutionId,
  AssociationResourceId,
  DateTime,
  AssociationResourceType,
  AssociationVersion
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class AssociationExecutionTarget(
    associationId: Option[AssociationId] = None,
    associationVersion: Option[AssociationVersion] = None,
    executionId: Option[AssociationExecutionId] = None,
    resourceId: Option[AssociationResourceId] = None,
    resourceType: Option[AssociationResourceType] = None,
    status: Option[StatusName] = None,
    detailedStatus: Option[StatusName] = None,
    lastExecutionDate: Option[DateTime] = None,
    outputSource: Option[zio.aws.ssm.model.OutputSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget = {
    import AssociationExecutionTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
      .builder()
      .optionallyWith(
        associationId.map(value =>
          AssociationId.unwrap(value): java.lang.String
        )
      )(_.associationId)
      .optionallyWith(
        associationVersion.map(value =>
          AssociationVersion.unwrap(value): java.lang.String
        )
      )(_.associationVersion)
      .optionallyWith(
        executionId.map(value =>
          AssociationExecutionId.unwrap(value): java.lang.String
        )
      )(_.executionId)
      .optionallyWith(
        resourceId.map(value =>
          AssociationResourceId.unwrap(value): java.lang.String
        )
      )(_.resourceId)
      .optionallyWith(
        resourceType.map(value =>
          AssociationResourceType.unwrap(value): java.lang.String
        )
      )(_.resourceType)
      .optionallyWith(
        status.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        detailedStatus.map(value => StatusName.unwrap(value): java.lang.String)
      )(_.detailedStatus)
      .optionallyWith(
        lastExecutionDate.map(value => DateTime.unwrap(value): Instant)
      )(_.lastExecutionDate)
      .optionallyWith(outputSource.map(value => value.buildAwsValue()))(
        _.outputSource
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly =
    zio.aws.ssm.model.AssociationExecutionTarget.wrap(buildAwsValue())
}
object AssociationExecutionTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.AssociationExecutionTarget =
      zio.aws.ssm.model.AssociationExecutionTarget(
        associationId.map(value => value),
        associationVersion.map(value => value),
        executionId.map(value => value),
        resourceId.map(value => value),
        resourceType.map(value => value),
        status.map(value => value),
        detailedStatus.map(value => value),
        lastExecutionDate.map(value => value),
        outputSource.map(value => value.asEditable)
      )
    def associationId: Option[AssociationId]
    def associationVersion: Option[AssociationVersion]
    def executionId: Option[AssociationExecutionId]
    def resourceId: Option[AssociationResourceId]
    def resourceType: Option[AssociationResourceType]
    def status: Option[StatusName]
    def detailedStatus: Option[StatusName]
    def lastExecutionDate: Option[DateTime]
    def outputSource: Option[zio.aws.ssm.model.OutputSource.ReadOnly]
    def getAssociationId: ZIO[Any, AwsError, AssociationId] =
      AwsError.unwrapOptionField("associationId", associationId)
    def getAssociationVersion: ZIO[Any, AwsError, AssociationVersion] =
      AwsError.unwrapOptionField("associationVersion", associationVersion)
    def getExecutionId: ZIO[Any, AwsError, AssociationExecutionId] =
      AwsError.unwrapOptionField("executionId", executionId)
    def getResourceId: ZIO[Any, AwsError, AssociationResourceId] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getResourceType: ZIO[Any, AwsError, AssociationResourceType] =
      AwsError.unwrapOptionField("resourceType", resourceType)
    def getStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("status", status)
    def getDetailedStatus: ZIO[Any, AwsError, StatusName] =
      AwsError.unwrapOptionField("detailedStatus", detailedStatus)
    def getLastExecutionDate: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("lastExecutionDate", lastExecutionDate)
    def getOutputSource
        : ZIO[Any, AwsError, zio.aws.ssm.model.OutputSource.ReadOnly] =
      AwsError.unwrapOptionField("outputSource", outputSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
  ) extends zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly {
    override val associationId: Option[AssociationId] = scala
      .Option(impl.associationId())
      .map(value => zio.aws.ssm.model.primitives.AssociationId(value))
    override val associationVersion: Option[AssociationVersion] = scala
      .Option(impl.associationVersion())
      .map(value => zio.aws.ssm.model.primitives.AssociationVersion(value))
    override val executionId: Option[AssociationExecutionId] = scala
      .Option(impl.executionId())
      .map(value => zio.aws.ssm.model.primitives.AssociationExecutionId(value))
    override val resourceId: Option[AssociationResourceId] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.ssm.model.primitives.AssociationResourceId(value))
    override val resourceType: Option[AssociationResourceType] = scala
      .Option(impl.resourceType())
      .map(value => zio.aws.ssm.model.primitives.AssociationResourceType(value))
    override val status: Option[StatusName] = scala
      .Option(impl.status())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val detailedStatus: Option[StatusName] = scala
      .Option(impl.detailedStatus())
      .map(value => zio.aws.ssm.model.primitives.StatusName(value))
    override val lastExecutionDate: Option[DateTime] = scala
      .Option(impl.lastExecutionDate())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val outputSource: Option[zio.aws.ssm.model.OutputSource.ReadOnly] =
      scala
        .Option(impl.outputSource())
        .map(value => zio.aws.ssm.model.OutputSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.AssociationExecutionTarget
  ): zio.aws.ssm.model.AssociationExecutionTarget.ReadOnly = new Wrapper(impl)
}
