package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentHash,
  Comment,
  ParameterName,
  ParameterValue,
  TimeoutSeconds,
  DocumentARN,
  InstanceId,
  S3Region,
  DocumentVersion,
  S3KeyPrefix,
  S3BucketName,
  ServiceRole,
  MaxConcurrency,
  MaxErrors
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SendCommandRequest(
    instanceIds: Option[Iterable[InstanceId]] = None,
    targets: Option[Iterable[zio.aws.ssm.model.Target]] = None,
    documentName: DocumentARN,
    documentVersion: Option[DocumentVersion] = None,
    documentHash: Option[DocumentHash] = None,
    documentHashType: Option[zio.aws.ssm.model.DocumentHashType] = None,
    timeoutSeconds: Option[TimeoutSeconds] = None,
    comment: Option[Comment] = None,
    parameters: Option[Map[ParameterName, Iterable[ParameterValue]]] = None,
    outputS3Region: Option[S3Region] = None,
    outputS3BucketName: Option[S3BucketName] = None,
    outputS3KeyPrefix: Option[S3KeyPrefix] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    serviceRoleArn: Option[ServiceRole] = None,
    notificationConfig: Option[zio.aws.ssm.model.NotificationConfig] = None,
    cloudWatchOutputConfig: Option[zio.aws.ssm.model.CloudWatchOutputConfig] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.SendCommandRequest = {
    import SendCommandRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.SendCommandRequest
      .builder()
      .optionallyWith(
        instanceIds.map(value =>
          value.map { item =>
            InstanceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.instanceIds)
      .optionallyWith(
        targets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targets)
      .documentName(DocumentARN.unwrap(documentName): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        documentHash.map(value => DocumentHash.unwrap(value): java.lang.String)
      )(_.documentHash)
      .optionallyWith(documentHashType.map(value => value.unwrap))(
        _.documentHashType
      )
      .optionallyWith(
        timeoutSeconds.map(value => TimeoutSeconds.unwrap(value): Integer)
      )(_.timeoutSeconds)
      .optionallyWith(
        comment.map(value => Comment.unwrap(value): java.lang.String)
      )(_.comment)
      .optionallyWith(
        parameters.map(value =>
          value
            .map({ case (key, value) =>
              (ParameterName.unwrap(key): java.lang.String) -> value.map {
                item =>
                  ParameterValue.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.parameters)
      .optionallyWith(
        outputS3Region.map(value => S3Region.unwrap(value): java.lang.String)
      )(_.outputS3Region)
      .optionallyWith(
        outputS3BucketName.map(value =>
          S3BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .optionallyWith(
        outputS3KeyPrefix.map(value =>
          S3KeyPrefix.unwrap(value): java.lang.String
        )
      )(_.outputS3KeyPrefix)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(
        serviceRoleArn.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRoleArn)
      .optionallyWith(notificationConfig.map(value => value.buildAwsValue()))(
        _.notificationConfig
      )
      .optionallyWith(
        cloudWatchOutputConfig.map(value => value.buildAwsValue())
      )(_.cloudWatchOutputConfig)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.SendCommandRequest.ReadOnly =
    zio.aws.ssm.model.SendCommandRequest.wrap(buildAwsValue())
}
object SendCommandRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.SendCommandRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.SendCommandRequest =
      zio.aws.ssm.model.SendCommandRequest(
        instanceIds.map(value => value),
        targets.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documentName,
        documentVersion.map(value => value),
        documentHash.map(value => value),
        documentHashType.map(value => value),
        timeoutSeconds.map(value => value),
        comment.map(value => value),
        parameters.map(value => value),
        outputS3Region.map(value => value),
        outputS3BucketName.map(value => value),
        outputS3KeyPrefix.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        serviceRoleArn.map(value => value),
        notificationConfig.map(value => value.asEditable),
        cloudWatchOutputConfig.map(value => value.asEditable)
      )
    def instanceIds: Option[List[InstanceId]]
    def targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]]
    def documentName: DocumentARN
    def documentVersion: Option[DocumentVersion]
    def documentHash: Option[DocumentHash]
    def documentHashType: Option[zio.aws.ssm.model.DocumentHashType]
    def timeoutSeconds: Option[TimeoutSeconds]
    def comment: Option[Comment]
    def parameters: Option[Map[ParameterName, List[ParameterValue]]]
    def outputS3Region: Option[S3Region]
    def outputS3BucketName: Option[S3BucketName]
    def outputS3KeyPrefix: Option[S3KeyPrefix]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def serviceRoleArn: Option[ServiceRole]
    def notificationConfig
        : Option[zio.aws.ssm.model.NotificationConfig.ReadOnly]
    def cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly]
    def getInstanceIds: ZIO[Any, AwsError, List[InstanceId]] =
      AwsError.unwrapOptionField("instanceIds", instanceIds)
    def getTargets
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.Target.ReadOnly]] =
      AwsError.unwrapOptionField("targets", targets)
    def getDocumentName: ZIO[Any, Nothing, DocumentARN] =
      ZIO.succeed(documentName)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getDocumentHash: ZIO[Any, AwsError, DocumentHash] =
      AwsError.unwrapOptionField("documentHash", documentHash)
    def getDocumentHashType
        : ZIO[Any, AwsError, zio.aws.ssm.model.DocumentHashType] =
      AwsError.unwrapOptionField("documentHashType", documentHashType)
    def getTimeoutSeconds: ZIO[Any, AwsError, TimeoutSeconds] =
      AwsError.unwrapOptionField("timeoutSeconds", timeoutSeconds)
    def getComment: ZIO[Any, AwsError, Comment] =
      AwsError.unwrapOptionField("comment", comment)
    def getParameters
        : ZIO[Any, AwsError, Map[ParameterName, List[ParameterValue]]] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getOutputS3Region: ZIO[Any, AwsError, S3Region] =
      AwsError.unwrapOptionField("outputS3Region", outputS3Region)
    def getOutputS3BucketName: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
    def getOutputS3KeyPrefix: ZIO[Any, AwsError, S3KeyPrefix] =
      AwsError.unwrapOptionField("outputS3KeyPrefix", outputS3KeyPrefix)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getServiceRoleArn: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRoleArn", serviceRoleArn)
    def getNotificationConfig
        : ZIO[Any, AwsError, zio.aws.ssm.model.NotificationConfig.ReadOnly] =
      AwsError.unwrapOptionField("notificationConfig", notificationConfig)
    def getCloudWatchOutputConfig: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly
    ] = AwsError.unwrapOptionField(
      "cloudWatchOutputConfig",
      cloudWatchOutputConfig
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.SendCommandRequest
  ) extends zio.aws.ssm.model.SendCommandRequest.ReadOnly {
    override val instanceIds: Option[List[InstanceId]] = scala
      .Option(impl.instanceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.InstanceId(item)
        }.toList
      )
    override val targets: Option[List[zio.aws.ssm.model.Target.ReadOnly]] =
      scala
        .Option(impl.targets())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.Target.wrap(item)
          }.toList
        )
    override val documentName: DocumentARN =
      zio.aws.ssm.model.primitives.DocumentARN(impl.documentName())
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val documentHash: Option[DocumentHash] = scala
      .Option(impl.documentHash())
      .map(value => zio.aws.ssm.model.primitives.DocumentHash(value))
    override val documentHashType: Option[zio.aws.ssm.model.DocumentHashType] =
      scala
        .Option(impl.documentHashType())
        .map(value => zio.aws.ssm.model.DocumentHashType.wrap(value))
    override val timeoutSeconds: Option[TimeoutSeconds] = scala
      .Option(impl.timeoutSeconds())
      .map(value => zio.aws.ssm.model.primitives.TimeoutSeconds(value))
    override val comment: Option[Comment] = scala
      .Option(impl.comment())
      .map(value => zio.aws.ssm.model.primitives.Comment(value))
    override val parameters: Option[Map[ParameterName, List[ParameterValue]]] =
      scala
        .Option(impl.parameters())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives
                .ParameterName(key) -> value.asScala.map { item =>
                zio.aws.ssm.model.primitives.ParameterValue(item)
              }.toList
            })
            .toMap
        )
    override val outputS3Region: Option[S3Region] = scala
      .Option(impl.outputS3Region())
      .map(value => zio.aws.ssm.model.primitives.S3Region(value))
    override val outputS3BucketName: Option[S3BucketName] = scala
      .Option(impl.outputS3BucketName())
      .map(value => zio.aws.ssm.model.primitives.S3BucketName(value))
    override val outputS3KeyPrefix: Option[S3KeyPrefix] = scala
      .Option(impl.outputS3KeyPrefix())
      .map(value => zio.aws.ssm.model.primitives.S3KeyPrefix(value))
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val serviceRoleArn: Option[ServiceRole] = scala
      .Option(impl.serviceRoleArn())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val notificationConfig
        : Option[zio.aws.ssm.model.NotificationConfig.ReadOnly] = scala
      .Option(impl.notificationConfig())
      .map(value => zio.aws.ssm.model.NotificationConfig.wrap(value))
    override val cloudWatchOutputConfig
        : Option[zio.aws.ssm.model.CloudWatchOutputConfig.ReadOnly] = scala
      .Option(impl.cloudWatchOutputConfig())
      .map(value => zio.aws.ssm.model.CloudWatchOutputConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.SendCommandRequest
  ): zio.aws.ssm.model.SendCommandRequest.ReadOnly = new Wrapper(impl)
}
