package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{OpsEntityItemKey, OpsEntityId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class OpsEntity(
    id: Option[OpsEntityId] = None,
    data: Option[Map[OpsEntityItemKey, zio.aws.ssm.model.OpsEntityItem]] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.ssm.model.OpsEntity = {
    import OpsEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.OpsEntity
      .builder()
      .optionallyWith(
        id.map(value => OpsEntityId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        data.map(value =>
          value
            .map({ case (key, value) =>
              (OpsEntityItemKey.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.OpsEntity.ReadOnly =
    zio.aws.ssm.model.OpsEntity.wrap(buildAwsValue())
}
object OpsEntity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.ssm.model.OpsEntity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.OpsEntity = zio.aws.ssm.model.OpsEntity(
      id.map(value => value),
      data.map(value =>
        value.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    )
    def id: Option[OpsEntityId]
    def data: Option[
      Map[OpsEntityItemKey, zio.aws.ssm.model.OpsEntityItem.ReadOnly]
    ]
    def getId: ZIO[Any, AwsError, OpsEntityId] =
      AwsError.unwrapOptionField("id", id)
    def getData: ZIO[Any, AwsError, Map[
      OpsEntityItemKey,
      zio.aws.ssm.model.OpsEntityItem.ReadOnly
    ]] = AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.OpsEntity
  ) extends zio.aws.ssm.model.OpsEntity.ReadOnly {
    override val id: Option[OpsEntityId] = scala
      .Option(impl.id())
      .map(value => zio.aws.ssm.model.primitives.OpsEntityId(value))
    override val data: Option[
      Map[OpsEntityItemKey, zio.aws.ssm.model.OpsEntityItem.ReadOnly]
    ] = scala
      .Option(impl.data())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.ssm.model.primitives.OpsEntityItemKey(
              key
            ) -> zio.aws.ssm.model.OpsEntityItem.wrap(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.OpsEntity
  ): zio.aws.ssm.model.OpsEntity.ReadOnly = new Wrapper(impl)
}
