package zio.aws.ssm.model
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTaskParameterName,
  MaintenanceWindowTaskPriority,
  MaintenanceWindowExecutionId,
  MaintenanceWindowTaskArn,
  DateTime,
  MaintenanceWindowExecutionTaskId,
  ServiceRole,
  MaxConcurrency,
  MaxErrors,
  MaintenanceWindowExecutionStatusDetails
}
import scala.jdk.CollectionConverters.*
final case class GetMaintenanceWindowExecutionTaskResponse(
    windowExecutionId: Option[MaintenanceWindowExecutionId] = None,
    taskExecutionId: Option[MaintenanceWindowExecutionTaskId] = None,
    taskArn: Option[MaintenanceWindowTaskArn] = None,
    serviceRole: Option[ServiceRole] = None,
    `type`: Option[zio.aws.ssm.model.MaintenanceWindowTaskType] = None,
    taskParameters: Option[Iterable[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
    ]]] = None,
    priority: Option[MaintenanceWindowTaskPriority] = None,
    maxConcurrency: Option[MaxConcurrency] = None,
    maxErrors: Option[MaxErrors] = None,
    status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = None,
    statusDetails: Option[MaintenanceWindowExecutionStatusDetails] = None,
    startTime: Option[DateTime] = None,
    endTime: Option[DateTime] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse = {
    import GetMaintenanceWindowExecutionTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
      .builder()
      .optionallyWith(
        windowExecutionId.map(value =>
          MaintenanceWindowExecutionId.unwrap(value): java.lang.String
        )
      )(_.windowExecutionId)
      .optionallyWith(
        taskExecutionId.map(value =>
          MaintenanceWindowExecutionTaskId.unwrap(value): java.lang.String
        )
      )(_.taskExecutionId)
      .optionallyWith(
        taskArn.map(value =>
          MaintenanceWindowTaskArn.unwrap(value): java.lang.String
        )
      )(_.taskArn)
      .optionallyWith(
        serviceRole.map(value => ServiceRole.unwrap(value): java.lang.String)
      )(_.serviceRole)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        taskParameters.map(value =>
          value.map { item =>
            item
              .map({ case (key, value) =>
                (MaintenanceWindowTaskParameterName.unwrap(
                  key
                ): java.lang.String) -> value.buildAwsValue()
              })
              .asJava
          }.asJavaCollection
        )
      )(_.taskParameters)
      .optionallyWith(
        priority.map(value =>
          MaintenanceWindowTaskPriority.unwrap(value): Integer
        )
      )(_.priority)
      .optionallyWith(
        maxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.maxConcurrency)
      .optionallyWith(
        maxErrors.map(value => MaxErrors.unwrap(value): java.lang.String)
      )(_.maxErrors)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDetails.map(value =>
          MaintenanceWindowExecutionStatusDetails.unwrap(
            value
          ): java.lang.String
        )
      )(_.statusDetails)
      .optionallyWith(startTime.map(value => DateTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => DateTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly =
    zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse
      .wrap(buildAwsValue())
}
object GetMaintenanceWindowExecutionTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse =
      zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse(
        windowExecutionId.map(value => value),
        taskExecutionId.map(value => value),
        taskArn.map(value => value),
        serviceRole.map(value => value),
        `type`.map(value => value),
        taskParameters.map(value =>
          value.map { item =>
            item.map({ case (key, value) =>
              key -> value.asEditable
            })
          }
        ),
        priority.map(value => value),
        maxConcurrency.map(value => value),
        maxErrors.map(value => value),
        status.map(value => value),
        statusDetails.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def windowExecutionId: Option[MaintenanceWindowExecutionId]
    def taskExecutionId: Option[MaintenanceWindowExecutionTaskId]
    def taskArn: Option[MaintenanceWindowTaskArn]
    def serviceRole: Option[ServiceRole]
    def `type`: Option[zio.aws.ssm.model.MaintenanceWindowTaskType]
    def taskParameters: Option[List[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]]
    def priority: Option[MaintenanceWindowTaskPriority]
    def maxConcurrency: Option[MaxConcurrency]
    def maxErrors: Option[MaxErrors]
    def status: Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus]
    def statusDetails: Option[MaintenanceWindowExecutionStatusDetails]
    def startTime: Option[DateTime]
    def endTime: Option[DateTime]
    def getWindowExecutionId: ZIO[Any, AwsError, MaintenanceWindowExecutionId] =
      AwsError.unwrapOptionField("windowExecutionId", windowExecutionId)
    def getTaskExecutionId
        : ZIO[Any, AwsError, MaintenanceWindowExecutionTaskId] =
      AwsError.unwrapOptionField("taskExecutionId", taskExecutionId)
    def getTaskArn: ZIO[Any, AwsError, MaintenanceWindowTaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getServiceRole: ZIO[Any, AwsError, ServiceRole] =
      AwsError.unwrapOptionField("serviceRole", serviceRole)
    def getType
        : ZIO[Any, AwsError, zio.aws.ssm.model.MaintenanceWindowTaskType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTaskParameters: ZIO[Any, AwsError, List[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]] = AwsError.unwrapOptionField("taskParameters", taskParameters)
    def getPriority: ZIO[Any, AwsError, MaintenanceWindowTaskPriority] =
      AwsError.unwrapOptionField("priority", priority)
    def getMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField("maxConcurrency", maxConcurrency)
    def getMaxErrors: ZIO[Any, AwsError, MaxErrors] =
      AwsError.unwrapOptionField("maxErrors", maxErrors)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.MaintenanceWindowExecutionStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getStatusDetails
        : ZIO[Any, AwsError, MaintenanceWindowExecutionStatusDetails] =
      AwsError.unwrapOptionField("statusDetails", statusDetails)
    def getStartTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, DateTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
  ) extends zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly {
    override val windowExecutionId: Option[MaintenanceWindowExecutionId] = scala
      .Option(impl.windowExecutionId())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowExecutionId(value)
      )
    override val taskExecutionId: Option[MaintenanceWindowExecutionTaskId] =
      scala
        .Option(impl.taskExecutionId())
        .map(value =>
          zio.aws.ssm.model.primitives.MaintenanceWindowExecutionTaskId(value)
        )
    override val taskArn: Option[MaintenanceWindowTaskArn] = scala
      .Option(impl.taskArn())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTaskArn(value)
      )
    override val serviceRole: Option[ServiceRole] = scala
      .Option(impl.serviceRole())
      .map(value => zio.aws.ssm.model.primitives.ServiceRole(value))
    override val `type`: Option[zio.aws.ssm.model.MaintenanceWindowTaskType] =
      scala
        .Option(impl.`type`())
        .map(value => zio.aws.ssm.model.MaintenanceWindowTaskType.wrap(value))
    override val taskParameters: Option[List[Map[
      MaintenanceWindowTaskParameterName,
      zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression.ReadOnly
    ]]] = scala
      .Option(impl.taskParameters())
      .map(value =>
        value.asScala.map { item =>
          item.asScala
            .map({ case (key, value) =>
              zio.aws.ssm.model.primitives.MaintenanceWindowTaskParameterName(
                key
              ) -> zio.aws.ssm.model.MaintenanceWindowTaskParameterValueExpression
                .wrap(value)
            })
            .toMap
        }.toList
      )
    override val priority: Option[MaintenanceWindowTaskPriority] = scala
      .Option(impl.priority())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowTaskPriority(value)
      )
    override val maxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.maxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val maxErrors: Option[MaxErrors] = scala
      .Option(impl.maxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val status
        : Option[zio.aws.ssm.model.MaintenanceWindowExecutionStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.ssm.model.MaintenanceWindowExecutionStatus.wrap(value)
      )
    override val statusDetails
        : Option[MaintenanceWindowExecutionStatusDetails] = scala
      .Option(impl.statusDetails())
      .map(value =>
        zio.aws.ssm.model.primitives
          .MaintenanceWindowExecutionStatusDetails(value)
      )
    override val startTime: Option[DateTime] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
    override val endTime: Option[DateTime] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.ssm.model.primitives.DateTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetMaintenanceWindowExecutionTaskResponse
  ): zio.aws.ssm.model.GetMaintenanceWindowExecutionTaskResponse.ReadOnly =
    new Wrapper(impl)
}
