package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  SessionManagerCloudWatchOutputUrl,
  SessionManagerS3OutputUrl
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SessionManagerOutputUrl(
    s3OutputUrl: Option[SessionManagerS3OutputUrl] = None,
    cloudWatchOutputUrl: Option[SessionManagerCloudWatchOutputUrl] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.SessionManagerOutputUrl = {
    import SessionManagerOutputUrl.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.SessionManagerOutputUrl
      .builder()
      .optionallyWith(
        s3OutputUrl.map(value =>
          SessionManagerS3OutputUrl.unwrap(value): java.lang.String
        )
      )(_.s3OutputUrl)
      .optionallyWith(
        cloudWatchOutputUrl.map(value =>
          SessionManagerCloudWatchOutputUrl.unwrap(value): java.lang.String
        )
      )(_.cloudWatchOutputUrl)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly =
    zio.aws.ssm.model.SessionManagerOutputUrl.wrap(buildAwsValue())
}
object SessionManagerOutputUrl {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.SessionManagerOutputUrl
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.SessionManagerOutputUrl =
      zio.aws.ssm.model.SessionManagerOutputUrl(
        s3OutputUrl.map(value => value),
        cloudWatchOutputUrl.map(value => value)
      )
    def s3OutputUrl: Option[SessionManagerS3OutputUrl]
    def cloudWatchOutputUrl: Option[SessionManagerCloudWatchOutputUrl]
    def getS3OutputUrl: ZIO[Any, AwsError, SessionManagerS3OutputUrl] =
      AwsError.unwrapOptionField("s3OutputUrl", s3OutputUrl)
    def getCloudWatchOutputUrl
        : ZIO[Any, AwsError, SessionManagerCloudWatchOutputUrl] =
      AwsError.unwrapOptionField("cloudWatchOutputUrl", cloudWatchOutputUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.SessionManagerOutputUrl
  ) extends zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly {
    override val s3OutputUrl: Option[SessionManagerS3OutputUrl] = scala
      .Option(impl.s3OutputUrl())
      .map(value =>
        zio.aws.ssm.model.primitives.SessionManagerS3OutputUrl(value)
      )
    override val cloudWatchOutputUrl
        : Option[SessionManagerCloudWatchOutputUrl] = scala
      .Option(impl.cloudWatchOutputUrl())
      .map(value =>
        zio.aws.ssm.model.primitives.SessionManagerCloudWatchOutputUrl(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.SessionManagerOutputUrl
  ): zio.aws.ssm.model.SessionManagerOutputUrl.ReadOnly = new Wrapper(impl)
}
