package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  SnapshotDownloadUrl,
  SnapshotId,
  InstanceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class GetDeployablePatchSnapshotForInstanceResponse(
    instanceId: Option[InstanceId] = None,
    snapshotId: Option[SnapshotId] = None,
    snapshotDownloadUrl: Option[SnapshotDownloadUrl] = None,
    product: Option[zio.aws.ssm.model.primitives.Product] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse = {
    import GetDeployablePatchSnapshotForInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        snapshotId.map(value => SnapshotId.unwrap(value): java.lang.String)
      )(_.snapshotId)
      .optionallyWith(
        snapshotDownloadUrl.map(value =>
          SnapshotDownloadUrl.unwrap(value): java.lang.String
        )
      )(_.snapshotDownloadUrl)
      .optionallyWith(
        product.map(value =>
          zio.aws.ssm.model.primitives.Product.unwrap(value): java.lang.String
        )
      )(_.product)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly =
    zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
      .wrap(buildAwsValue())
}
object GetDeployablePatchSnapshotForInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse =
      zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse(
        instanceId.map(value => value),
        snapshotId.map(value => value),
        snapshotDownloadUrl.map(value => value),
        product.map(value => value)
      )
    def instanceId: Option[InstanceId]
    def snapshotId: Option[SnapshotId]
    def snapshotDownloadUrl: Option[SnapshotDownloadUrl]
    def product: Option[zio.aws.ssm.model.primitives.Product]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getSnapshotId: ZIO[Any, AwsError, SnapshotId] =
      AwsError.unwrapOptionField("snapshotId", snapshotId)
    def getSnapshotDownloadUrl: ZIO[Any, AwsError, SnapshotDownloadUrl] =
      AwsError.unwrapOptionField("snapshotDownloadUrl", snapshotDownloadUrl)
    def getProduct: ZIO[Any, AwsError, zio.aws.ssm.model.primitives.Product] =
      AwsError.unwrapOptionField("product", product)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
  ) extends zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly {
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value => zio.aws.ssm.model.primitives.InstanceId(value))
    override val snapshotId: Option[SnapshotId] = scala
      .Option(impl.snapshotId())
      .map(value => zio.aws.ssm.model.primitives.SnapshotId(value))
    override val snapshotDownloadUrl: Option[SnapshotDownloadUrl] = scala
      .Option(impl.snapshotDownloadUrl())
      .map(value => zio.aws.ssm.model.primitives.SnapshotDownloadUrl(value))
    override val product: Option[zio.aws.ssm.model.primitives.Product] = scala
      .Option(impl.product())
      .map(value => zio.aws.ssm.model.primitives.Product(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.GetDeployablePatchSnapshotForInstanceResponse
  ): zio.aws.ssm.model.GetDeployablePatchSnapshotForInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
