package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{NextToken, PatchBaselineMaxResults}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribePatchBaselinesRequest(
    filters: Option[Iterable[zio.aws.ssm.model.PatchOrchestratorFilter]] = None,
    maxResults: Option[PatchBaselineMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest = {
    import DescribePatchBaselinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => PatchBaselineMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DescribePatchBaselinesRequest.ReadOnly =
    zio.aws.ssm.model.DescribePatchBaselinesRequest.wrap(buildAwsValue())
}
object DescribePatchBaselinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DescribePatchBaselinesRequest =
      zio.aws.ssm.model.DescribePatchBaselinesRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def filters
        : Option[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]]
    def maxResults: Option[PatchBaselineMaxResults]
    def nextToken: Option[NextToken]
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, PatchBaselineMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
  ) extends zio.aws.ssm.model.DescribePatchBaselinesRequest.ReadOnly {
    override val filters
        : Option[List[zio.aws.ssm.model.PatchOrchestratorFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.PatchOrchestratorFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[PatchBaselineMaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.ssm.model.primitives.PatchBaselineMaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribePatchBaselinesRequest
  ): zio.aws.ssm.model.DescribePatchBaselinesRequest.ReadOnly = new Wrapper(
    impl
  )
}
