package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowTargetId,
  MaintenanceWindowId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeregisterTargetFromMaintenanceWindowRequest(
    windowId: MaintenanceWindowId,
    windowTargetId: MaintenanceWindowTargetId,
    safe: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest = {
    import DeregisterTargetFromMaintenanceWindowRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
      .builder()
      .windowId(MaintenanceWindowId.unwrap(windowId): java.lang.String)
      .windowTargetId(
        MaintenanceWindowTargetId.unwrap(windowTargetId): java.lang.String
      )
      .optionallyWith(safe.map(value => value: java.lang.Boolean))(_.safe)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest.ReadOnly =
    zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
      .wrap(buildAwsValue())
}
object DeregisterTargetFromMaintenanceWindowRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest =
      zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest(
        windowId,
        windowTargetId,
        safe.map(value => value)
      )
    def windowId: MaintenanceWindowId
    def windowTargetId: MaintenanceWindowTargetId
    def safe: Option[Boolean]
    def getWindowId: ZIO[Any, Nothing, MaintenanceWindowId] =
      ZIO.succeed(windowId)
    def getWindowTargetId: ZIO[Any, Nothing, MaintenanceWindowTargetId] =
      ZIO.succeed(windowTargetId)
    def getSafe: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("safe", safe)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
  ) extends zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest.ReadOnly {
    override val windowId: MaintenanceWindowId =
      zio.aws.ssm.model.primitives.MaintenanceWindowId(impl.windowId())
    override val windowTargetId: MaintenanceWindowTargetId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowTargetId(impl.windowTargetId())
    override val safe: Option[Boolean] =
      scala.Option(impl.safe()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeregisterTargetFromMaintenanceWindowRequest
  ): zio.aws.ssm.model.DeregisterTargetFromMaintenanceWindowRequest.ReadOnly =
    new Wrapper(impl)
}
