package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListComplianceItemsResponse(
    complianceItems: Option[Iterable[zio.aws.ssm.model.ComplianceItem]] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse = {
    import ListComplianceItemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse
      .builder()
      .optionallyWith(
        complianceItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.complianceItems)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly =
    zio.aws.ssm.model.ListComplianceItemsResponse.wrap(buildAwsValue())
}
object ListComplianceItemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.ListComplianceItemsResponse =
      zio.aws.ssm.model.ListComplianceItemsResponse(
        complianceItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def complianceItems: Option[List[zio.aws.ssm.model.ComplianceItem.ReadOnly]]
    def nextToken: Option[NextToken]
    def getComplianceItems
        : ZIO[Any, AwsError, List[zio.aws.ssm.model.ComplianceItem.ReadOnly]] =
      AwsError.unwrapOptionField("complianceItems", complianceItems)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse
  ) extends zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly {
    override val complianceItems
        : Option[List[zio.aws.ssm.model.ComplianceItem.ReadOnly]] = scala
      .Option(impl.complianceItems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.ComplianceItem.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.ListComplianceItemsResponse
  ): zio.aws.ssm.model.ListComplianceItemsResponse.ReadOnly = new Wrapper(impl)
}
