package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{ResourceDataSyncType, ResourceDataSyncName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateResourceDataSyncRequest(
    syncName: ResourceDataSyncName,
    s3Destination: Option[zio.aws.ssm.model.ResourceDataSyncS3Destination] =
      None,
    syncType: Option[ResourceDataSyncType] = None,
    syncSource: Option[zio.aws.ssm.model.ResourceDataSyncSource] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest = {
    import CreateResourceDataSyncRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest
      .builder()
      .syncName(ResourceDataSyncName.unwrap(syncName): java.lang.String)
      .optionallyWith(s3Destination.map(value => value.buildAwsValue()))(
        _.s3Destination
      )
      .optionallyWith(
        syncType.map(value =>
          ResourceDataSyncType.unwrap(value): java.lang.String
        )
      )(_.syncType)
      .optionallyWith(syncSource.map(value => value.buildAwsValue()))(
        _.syncSource
      )
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateResourceDataSyncRequest.ReadOnly =
    zio.aws.ssm.model.CreateResourceDataSyncRequest.wrap(buildAwsValue())
}
object CreateResourceDataSyncRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateResourceDataSyncRequest =
      zio.aws.ssm.model.CreateResourceDataSyncRequest(
        syncName,
        s3Destination.map(value => value.asEditable),
        syncType.map(value => value),
        syncSource.map(value => value.asEditable)
      )
    def syncName: ResourceDataSyncName
    def s3Destination
        : Option[zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly]
    def syncType: Option[ResourceDataSyncType]
    def syncSource: Option[zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly]
    def getSyncName: ZIO[Any, Nothing, ResourceDataSyncName] =
      ZIO.succeed(syncName)
    def getS3Destination: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly
    ] = AwsError.unwrapOptionField("s3Destination", s3Destination)
    def getSyncType: ZIO[Any, AwsError, ResourceDataSyncType] =
      AwsError.unwrapOptionField("syncType", syncType)
    def getSyncSource: ZIO[
      Any,
      AwsError,
      zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly
    ] = AwsError.unwrapOptionField("syncSource", syncSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest
  ) extends zio.aws.ssm.model.CreateResourceDataSyncRequest.ReadOnly {
    override val syncName: ResourceDataSyncName =
      zio.aws.ssm.model.primitives.ResourceDataSyncName(impl.syncName())
    override val s3Destination
        : Option[zio.aws.ssm.model.ResourceDataSyncS3Destination.ReadOnly] =
      scala
        .Option(impl.s3Destination())
        .map(value =>
          zio.aws.ssm.model.ResourceDataSyncS3Destination.wrap(value)
        )
    override val syncType: Option[ResourceDataSyncType] = scala
      .Option(impl.syncType())
      .map(value => zio.aws.ssm.model.primitives.ResourceDataSyncType(value))
    override val syncSource
        : Option[zio.aws.ssm.model.ResourceDataSyncSource.ReadOnly] = scala
      .Option(impl.syncSource())
      .map(value => zio.aws.ssm.model.ResourceDataSyncSource.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateResourceDataSyncRequest
  ): zio.aws.ssm.model.CreateResourceDataSyncRequest.ReadOnly = new Wrapper(
    impl
  )
}
