package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  MaintenanceWindowStepFunctionsName,
  MaintenanceWindowStepFunctionsInput
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class MaintenanceWindowStepFunctionsParameters(
    input: Option[MaintenanceWindowStepFunctionsInput] = None,
    name: Option[MaintenanceWindowStepFunctionsName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.MaintenanceWindowStepFunctionsParameters = {
    import MaintenanceWindowStepFunctionsParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowStepFunctionsParameters
      .builder()
      .optionallyWith(
        input.map(value =>
          MaintenanceWindowStepFunctionsInput.unwrap(value): java.lang.String
        )
      )(_.input)
      .optionallyWith(
        name.map(value =>
          MaintenanceWindowStepFunctionsName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters.ReadOnly =
    zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters
      .wrap(buildAwsValue())
}
object MaintenanceWindowStepFunctionsParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.MaintenanceWindowStepFunctionsParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters =
      zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters(
        input.map(value => value),
        name.map(value => value)
      )
    def input: Option[MaintenanceWindowStepFunctionsInput]
    def name: Option[MaintenanceWindowStepFunctionsName]
    def getInput: ZIO[Any, AwsError, MaintenanceWindowStepFunctionsInput] =
      AwsError.unwrapOptionField("input", input)
    def getName: ZIO[Any, AwsError, MaintenanceWindowStepFunctionsName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowStepFunctionsParameters
  ) extends zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters.ReadOnly {
    override val input: Option[MaintenanceWindowStepFunctionsInput] = scala
      .Option(impl.input())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowStepFunctionsInput(value)
      )
    override val name: Option[MaintenanceWindowStepFunctionsName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowStepFunctionsName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.MaintenanceWindowStepFunctionsParameters
  ): zio.aws.ssm.model.MaintenanceWindowStepFunctionsParameters.ReadOnly =
    new Wrapper(impl)
}
