package zio.aws.ssm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class CreateAssociationBatchResponse(
    successful: Option[Iterable[zio.aws.ssm.model.AssociationDescription]] =
      None,
    failed: Option[Iterable[zio.aws.ssm.model.FailedCreateAssociation]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse = {
    import CreateAssociationBatchResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse
      .builder()
      .optionallyWith(
        successful.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.successful)
      .optionallyWith(
        failed.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failed)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly =
    zio.aws.ssm.model.CreateAssociationBatchResponse.wrap(buildAwsValue())
}
object CreateAssociationBatchResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.CreateAssociationBatchResponse =
      zio.aws.ssm.model.CreateAssociationBatchResponse(
        successful.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        failed.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def successful
        : Option[List[zio.aws.ssm.model.AssociationDescription.ReadOnly]]
    def failed: Option[List[zio.aws.ssm.model.FailedCreateAssociation.ReadOnly]]
    def getSuccessful: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.AssociationDescription.ReadOnly
    ]] = AwsError.unwrapOptionField("successful", successful)
    def getFailed: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.FailedCreateAssociation.ReadOnly
    ]] = AwsError.unwrapOptionField("failed", failed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse
  ) extends zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly {
    override val successful
        : Option[List[zio.aws.ssm.model.AssociationDescription.ReadOnly]] =
      scala
        .Option(impl.successful())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.AssociationDescription.wrap(item)
          }.toList
        )
    override val failed
        : Option[List[zio.aws.ssm.model.FailedCreateAssociation.ReadOnly]] =
      scala
        .Option(impl.failed())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.FailedCreateAssociation.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.CreateAssociationBatchResponse
  ): zio.aws.ssm.model.CreateAssociationBatchResponse.ReadOnly = new Wrapper(
    impl
  )
}
