package zio.aws.ssm.model
import scala.jdk.CollectionConverters.*
sealed trait PatchFilterKey {
  def unwrap: software.amazon.awssdk.services.ssm.model.PatchFilterKey
}
object PatchFilterKey {
  def wrap(
      value: software.amazon.awssdk.services.ssm.model.PatchFilterKey
  ): zio.aws.ssm.model.PatchFilterKey = value match {
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.ARCH =>
      val r = ARCH
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.ADVISORY_ID =>
      val r = ADVISORY_ID
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.BUGZILLA_ID =>
      val r = BUGZILLA_ID
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.PATCH_SET =>
      val r = PATCH_SET
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.PRODUCT =>
      val r = PRODUCT
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.PRODUCT_FAMILY =>
      val r = PRODUCT_FAMILY
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.CLASSIFICATION =>
      val r = CLASSIFICATION
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.CVE_ID =>
      val r = CVE_ID
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.EPOCH =>
      val r = EPOCH
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.MSRC_SEVERITY =>
      val r = MSRC_SEVERITY
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.NAME =>
      val r = NAME
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.PATCH_ID =>
      val r = PATCH_ID
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.SECTION =>
      val r = SECTION
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.PRIORITY =>
      val r = PRIORITY
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.REPOSITORY =>
      val r = REPOSITORY
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.RELEASE =>
      val r = RELEASE
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.SEVERITY =>
      val r = SEVERITY
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.SECURITY =>
      val r = SECURITY
      r
    case software.amazon.awssdk.services.ssm.model.PatchFilterKey.VERSION =>
      val r = VERSION
      r
  }
  case object unknownToSdkVersion extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.UNKNOWN_TO_SDK_VERSION
  }
  case object ARCH extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.ARCH
  }
  case object ADVISORY_ID extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.ADVISORY_ID
  }
  case object BUGZILLA_ID extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.BUGZILLA_ID
  }
  case object PATCH_SET extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.PATCH_SET
  }
  case object PRODUCT extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.PRODUCT
  }
  case object PRODUCT_FAMILY extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.PRODUCT_FAMILY
  }
  case object CLASSIFICATION extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.CLASSIFICATION
  }
  case object CVE_ID extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.CVE_ID
  }
  case object EPOCH extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.EPOCH
  }
  case object MSRC_SEVERITY extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.MSRC_SEVERITY
  }
  case object NAME extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.NAME
  }
  case object PATCH_ID extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.PATCH_ID
  }
  case object SECTION extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.SECTION
  }
  case object PRIORITY extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.PRIORITY
  }
  case object REPOSITORY extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.REPOSITORY
  }
  case object RELEASE extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.RELEASE
  }
  case object SEVERITY extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.SEVERITY
  }
  case object SECURITY extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.SECURITY
  }
  case object VERSION extends zio.aws.ssm.model.PatchFilterKey {
    override def unwrap
        : software.amazon.awssdk.services.ssm.model.PatchFilterKey =
      software.amazon.awssdk.services.ssm.model.PatchFilterKey.VERSION
  }
}
