package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  NextToken,
  MaintenanceWindowMaxResults,
  MaintenanceWindowExecutionId
}
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeMaintenanceWindowExecutionTasksRequest(
    windowExecutionId: MaintenanceWindowExecutionId,
    filters: Option[Iterable[zio.aws.ssm.model.MaintenanceWindowFilter]] = None,
    maxResults: Option[MaintenanceWindowMaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest = {
    import DescribeMaintenanceWindowExecutionTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
      .builder()
      .windowExecutionId(
        MaintenanceWindowExecutionId.unwrap(windowExecutionId): java.lang.String
      )
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value =>
          MaintenanceWindowMaxResults.unwrap(value): Integer
        )
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest.ReadOnly =
    zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
      .wrap(buildAwsValue())
}
object DescribeMaintenanceWindowExecutionTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest =
      zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest(
        windowExecutionId,
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def windowExecutionId: MaintenanceWindowExecutionId
    def filters
        : Option[List[zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly]]
    def maxResults: Option[MaintenanceWindowMaxResults]
    def nextToken: Option[NextToken]
    def getWindowExecutionId: ZIO[Any, Nothing, MaintenanceWindowExecutionId] =
      ZIO.succeed(windowExecutionId)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaintenanceWindowMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
  ) extends zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest.ReadOnly {
    override val windowExecutionId: MaintenanceWindowExecutionId =
      zio.aws.ssm.model.primitives
        .MaintenanceWindowExecutionId(impl.windowExecutionId())
    override val filters
        : Option[List[zio.aws.ssm.model.MaintenanceWindowFilter.ReadOnly]] =
      scala
        .Option(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.ssm.model.MaintenanceWindowFilter.wrap(item)
          }.toList
        )
    override val maxResults: Option[MaintenanceWindowMaxResults] = scala
      .Option(impl.maxResults())
      .map(value =>
        zio.aws.ssm.model.primitives.MaintenanceWindowMaxResults(value)
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.ssm.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest
  ): zio.aws.ssm.model.DescribeMaintenanceWindowExecutionTasksRequest.ReadOnly =
    new Wrapper(impl)
}
