package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  DocumentVersionName,
  DocumentVersion,
  DocumentName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DeleteDocumentRequest(
    name: DocumentName,
    documentVersion: Option[DocumentVersion] = None,
    versionName: Option[DocumentVersionName] = None,
    force: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest = {
    import DeleteDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest
      .builder()
      .name(DocumentName.unwrap(name): java.lang.String)
      .optionallyWith(
        documentVersion.map(value =>
          DocumentVersion.unwrap(value): java.lang.String
        )
      )(_.documentVersion)
      .optionallyWith(
        versionName.map(value =>
          DocumentVersionName.unwrap(value): java.lang.String
        )
      )(_.versionName)
      .optionallyWith(force.map(value => value: java.lang.Boolean))(_.force)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.DeleteDocumentRequest.ReadOnly =
    zio.aws.ssm.model.DeleteDocumentRequest.wrap(buildAwsValue())
}
object DeleteDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.DeleteDocumentRequest =
      zio.aws.ssm.model.DeleteDocumentRequest(
        name,
        documentVersion.map(value => value),
        versionName.map(value => value),
        force.map(value => value)
      )
    def name: DocumentName
    def documentVersion: Option[DocumentVersion]
    def versionName: Option[DocumentVersionName]
    def force: Option[Boolean]
    def getName: ZIO[Any, Nothing, DocumentName] = ZIO.succeed(name)
    def getDocumentVersion: ZIO[Any, AwsError, DocumentVersion] =
      AwsError.unwrapOptionField("documentVersion", documentVersion)
    def getVersionName: ZIO[Any, AwsError, DocumentVersionName] =
      AwsError.unwrapOptionField("versionName", versionName)
    def getForce: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("force", force)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest
  ) extends zio.aws.ssm.model.DeleteDocumentRequest.ReadOnly {
    override val name: DocumentName =
      zio.aws.ssm.model.primitives.DocumentName(impl.name())
    override val documentVersion: Option[DocumentVersion] = scala
      .Option(impl.documentVersion())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersion(value))
    override val versionName: Option[DocumentVersionName] = scala
      .Option(impl.versionName())
      .map(value => zio.aws.ssm.model.primitives.DocumentVersionName(value))
    override val force: Option[Boolean] =
      scala.Option(impl.force()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.DeleteDocumentRequest
  ): zio.aws.ssm.model.DeleteDocumentRequest.ReadOnly = new Wrapper(impl)
}
