package zio.aws.ssm.model
import zio.aws.ssm.model.primitives.{
  Account,
  Region,
  ExecutionRoleName,
  MaxConcurrency,
  MaxErrors
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class TargetLocation(
    accounts: Option[Iterable[Account]] = None,
    regions: Option[Iterable[Region]] = None,
    targetLocationMaxConcurrency: Option[MaxConcurrency] = None,
    targetLocationMaxErrors: Option[MaxErrors] = None,
    executionRoleName: Option[ExecutionRoleName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.ssm.model.TargetLocation = {
    import TargetLocation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.ssm.model.TargetLocation
      .builder()
      .optionallyWith(
        accounts.map(value =>
          value.map { item =>
            Account.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.accounts)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            Region.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.regions)
      .optionallyWith(
        targetLocationMaxConcurrency.map(value =>
          MaxConcurrency.unwrap(value): java.lang.String
        )
      )(_.targetLocationMaxConcurrency)
      .optionallyWith(
        targetLocationMaxErrors.map(value =>
          MaxErrors.unwrap(value): java.lang.String
        )
      )(_.targetLocationMaxErrors)
      .optionallyWith(
        executionRoleName.map(value =>
          ExecutionRoleName.unwrap(value): java.lang.String
        )
      )(_.executionRoleName)
      .build()
  }
  def asReadOnly: zio.aws.ssm.model.TargetLocation.ReadOnly =
    zio.aws.ssm.model.TargetLocation.wrap(buildAwsValue())
}
object TargetLocation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.ssm.model.TargetLocation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.ssm.model.TargetLocation =
      zio.aws.ssm.model.TargetLocation(
        accounts.map(value => value),
        regions.map(value => value),
        targetLocationMaxConcurrency.map(value => value),
        targetLocationMaxErrors.map(value => value),
        executionRoleName.map(value => value)
      )
    def accounts: Option[List[Account]]
    def regions: Option[List[Region]]
    def targetLocationMaxConcurrency: Option[MaxConcurrency]
    def targetLocationMaxErrors: Option[MaxErrors]
    def executionRoleName: Option[ExecutionRoleName]
    def getAccounts: ZIO[Any, AwsError, List[Account]] =
      AwsError.unwrapOptionField("accounts", accounts)
    def getRegions: ZIO[Any, AwsError, List[Region]] =
      AwsError.unwrapOptionField("regions", regions)
    def getTargetLocationMaxConcurrency: ZIO[Any, AwsError, MaxConcurrency] =
      AwsError.unwrapOptionField(
        "targetLocationMaxConcurrency",
        targetLocationMaxConcurrency
      )
    def getTargetLocationMaxErrors: ZIO[Any, AwsError, MaxErrors] = AwsError
      .unwrapOptionField("targetLocationMaxErrors", targetLocationMaxErrors)
    def getExecutionRoleName: ZIO[Any, AwsError, ExecutionRoleName] =
      AwsError.unwrapOptionField("executionRoleName", executionRoleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.ssm.model.TargetLocation
  ) extends zio.aws.ssm.model.TargetLocation.ReadOnly {
    override val accounts: Option[List[Account]] = scala
      .Option(impl.accounts())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Account(item)
        }.toList
      )
    override val regions: Option[List[Region]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.ssm.model.primitives.Region(item)
        }.toList
      )
    override val targetLocationMaxConcurrency: Option[MaxConcurrency] = scala
      .Option(impl.targetLocationMaxConcurrency())
      .map(value => zio.aws.ssm.model.primitives.MaxConcurrency(value))
    override val targetLocationMaxErrors: Option[MaxErrors] = scala
      .Option(impl.targetLocationMaxErrors())
      .map(value => zio.aws.ssm.model.primitives.MaxErrors(value))
    override val executionRoleName: Option[ExecutionRoleName] = scala
      .Option(impl.executionRoleName())
      .map(value => zio.aws.ssm.model.primitives.ExecutionRoleName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.ssm.model.TargetLocation
  ): zio.aws.ssm.model.TargetLocation.ReadOnly = new Wrapper(impl)
}
